# frozen_string_literal: true

# Map a code bock onto an array, where each array element executes in parallel.
# This function is experimental.
#
# > **Note:** Not available in apply block.
Puppet::Functions.create_function(:parallelize, Puppet::Functions::InternalFunction) do
  # Map a block onto an array, where each array element executes in parallel.
  # This function is experimental.
  # @param data The array to apply the block to.
  # @return [Array] An array of PlanResult objects. Each input from the input
  #   array returns a corresponding PlanResult object.
  # @example Execute two tasks on multiple targets. Once the task finishes on one
  #   target, that target can move to the next step without waiting for the task
  #   to finish on the second target.
  # $targets = get_targets(["host1", "host2"])
  # $result = parallelize ($targets) |$t| {
  #   run_task('a', $t)
  #   run_task('b', $t)
  # }
  dispatch :parallelize do
    scope_param
    param 'Array[Any]', :data
    block_param 'Callable[Any]', :block
    return_type 'Array[Boltlib::PlanResult]'
  end

  def parallelize(scope, data, &block)
    unless Puppet[:tasks]
      raise Puppet::ParseErrorWithIssue
        .from_issue_and_stack(
          Bolt::PAL::Issues::PLAN_OPERATION_NOT_SUPPORTED_WHEN_COMPILING,
          action: 'parallelize'
        )
    end
    raise Puppet::Error, "parallelize is currently not supported in PE plans"
  end
end
