#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'

class EnsureCompilerCSRAttributes < EnterpriseTaskHelper
  def task(_)
    csr_attributes = '/etc/puppetlabs/puppet/csr_attributes.yaml'

    # If the csr_attributes file is missing on a PE Compiler and we're
    # regenerating certificates, we need to lay down a basic one so that
    # we get the required cert extension for the compiler.
    if !File.exist?(csr_attributes)
      csr_attributes_content = <<~HEREDOC
        ---
        extension_requests:
          pp_auth_role: pe_compiler
      HEREDOC
      File.write(csr_attributes, csr_attributes_content)
    end
  end
end

EnsureCompilerCSRAttributes.run if __FILE__ == $PROGRAM_NAME
