INSTALL_DIR="/opt/puppetlabs/server/apps/puppetserver"
USER_JARS="/opt/puppetlabs/server/data/puppetserver/jars/*"

JRUBY_JAR="${JRUBY_JAR:-${INSTALL_DIR}/jruby-9k.jar}"
SHARED_DIR="/opt/puppetlabs/share/java"
BC_DEFAULT="${SHARED_DIR}/bcprov-jdk18on.jar:${SHARED_DIR}/bcpkix-jdk18on.jar:${SHARED_DIR}/bcutil-jdk18on.jar:${SHARED_DIR}/bctls-jdk18on.jar"
BC_JAR="${BC_JAR:-$BC_DEFAULT}"

if [ ! -e "$JRUBY_JAR" ]; then
  echo "Unable to find specified JRUBY_JAR: ${JRUBY_JAR}" 1>&2
  return 1
fi

CLASSPATH="${CLASSPATH}:${JRUBY_JAR}:${BC_JAR}:${USER_JARS}"

java_version=$($JAVA_BIN -version 2>&1 | head -1 | awk -F\" '{ print $2 }')
java_major_version=$(echo $java_version | awk -F. '{ print $1 }')

if [[ $java_major_version -eq 17 ]]; then

	echo $JAVA_ARGS | grep "add-opens" &>/dev/null
	if [[ 0 -ne $? ]]; then
		export JAVA_ARGS="--add-opens java.base/sun.nio.ch=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED ${JAVA_ARGS}"
	fi

	echo $JAVA_ARGS_CLI | grep "add-opens" &>/dev/null
	if [[ 0 -ne $? ]]; then
		export JAVA_ARGS_CLI="--add-opens java.base/sun.nio.ch=ALL-UNNAMED --add-opens java.base/java.io=ALL-UNNAMED ${JAVA_ARGS_CLI}"
	fi
fi
