# Migrate the Certificate Authority directory to it's Puppet 7
# /etc/puppetlabs/puppetserver/ca location. Does nothing if
# /etc/puppetlabs/puppetserver/ca already exists.
#
# Should only be included in the primary catalog (so when $::pe_install::is_ca
# is true).
#
# If it executes, it will create timestamped backup of the
# /etc/puppetlabs/puppet/ssl/ca files in /var/puppetlabs/backups first.
#
# @param is_upgrade True if we are performing an upgrade instead of an
# initial install or repair.
class pe_install::upgrade::migrate_ca_directory (
  Boolean $is_upgrade = $pe_install::is_upgrade,
) {
  if $is_upgrade {
    Class['puppet_enterprise::master']
    -> Class['pe_install::upgrade::migrate_ca_directory']
    -> Puppet_enterprise::Trapperkeeper::Pe_service['puppetserver']

    $puppet_ssl_dir = '/etc/puppetlabs/puppet/ssl'
    $puppet_6_ca_dir = "${puppet_ssl_dir}/ca"
    $puppet_7_ca_dir = '/etc/puppetlabs/puppetserver/ca'

    # Running umask and tar within the sub shell invocation is to protect umask from
    # interfering with execution of puppetserver ca migrate.
    $migrate_command = @("EOS"/L)
      sh -c \
        'umask 0077 && \
         tar chzf "/var/puppetlabs/backups/puppet-cadir-$(date +%y%m%d%H%M%S).tar.gz" ${puppet_6_ca_dir}' && \
      /opt/puppetlabs/bin/puppetserver ca migrate
      |- EOS
    exec { "Migrating CA directory to ${puppet_7_ca_dir}":
      command   => $migrate_command,
      unless    => "test -d ${puppet_7_ca_dir}",
      path      => $facts['path'],
      logoutput => true,
    }
  }
}
