# High Availability Overview

## What HA does

High availability ("HA") in PE currently focuses on two things:
* keeping puppet runs working if an essential component on the primary
  fails, so that state enforcement can continue
* allowing customers to use their replica to replace their primary if it
  breaks and is too difficult to fix

We want:
* automatic failover by the requesting process over to the replica if, during a
  Puppet run, attempting to contact a component on the primary node fails
* the replica node to match the primary node's state as closely as is reasonable
  at all times, so that failovers to the replica are not likely to produce
  different results than running on the primary, and so that the replica can be a
  good replacement for the primary if a full promotion is necessary

Therefore, HA as a system needs to do a number of things:
* Any software that makes requests essential to the completion of a Puppet run
  needs to be able to fail over to the replica node if their first request to a
  component on the primary node fails (and in some cases, if the subsequent ones
  fail -- whether or not to fail the run if subsequent requests fail is up to the
  component, because different components may have different consistency
  concerns).
* Copy the state of the primary node to the replica node continuously, to have
  the two nodes match state as closely as is reasonable at all times, so that
  failovers to the replica produce the same result as running on the primary

Important notes:
* The Puppet agent (or load balancer, if configured) shouldn't fail over to the
  replica Puppet Server if the primary Puppet Server has already been contacted
  in a run; this is to avoid confusing and/or inconsistent state. It should
  always use a single Puppet Server instance per run.

## Terms

Primary server node (formerly Master of Masters or MoM) -- the original, primary server
for your infrastructure. Originally used to distinguish from compilers, this term
can still refer to the primary in your infrastructure even when you
don't have any compilers -- the important part is the software + data on
it that compilers never have. Contains all parts of a monolithic PE
install.

Replica node -- a node meant to be able to stand in for some functions of the
primary during a Puppet run, and that can be "promoted" via a command
to replace the MoM.

Compilers -- optional for HA, runs an instance of Puppet server and a PCP
broker (starting in Glisan, 2017.2.x).

Infrastructure nodes -- Any nodes primarily used to keep your Puppet
infrastructure working, and as such, should have its agent connect directly to
the primary in a compiler installation (since compiler failures could
then prevent it from getting fixed in a failure -- but a direct connection to
the primary allows you to fix the primary and then use that to push out changes). These
are the nodes that host any Puppet Server instances (primary, replica, compilers), 
as well as console or DB nodes in a split install. This can also
include load balancers between agents and compilers if users do the work
to classify them as such, since we don't configure load balancers for
customers.

## How much does this repo do

The logic in this repository is responsible for installing and configuring the
software in PE. This means putting necessary software on the replica node when
it is provisioned, setting up data replication, and then configuring services
to point to primary and replica services at the appropriate points in time.

This repository does not determine failover logic. That is up to the requesting
components, e.g., the puppet agent (for Puppet servers or PCP brokers), or
termini (for classifier or PuppetDB failovers).

## `puppet infrastructure` Commands

The following commands must be used to prepare for a HA setup:

* [provision](./infrastructure_provision_replica.md) - provisions a new replica
node based on the primary, duplicating its services and components. This
synchronization process is expensive and will take time to fully sync, dependent
on the size of the data set.

* [status](../infrastructure_status.md) - tracks the sync progress of the replica.
A replica cannot be enabled until syncing is complete.

* [enable](./infrastructure_enable_replica.md) - enables a provisioned replica to
act as a failover for the primary by updating classifications and configuring
infrastructure to be aware of the replica.

Once a replica has been established, the following commands may be used to further
modify the state of the PE infrastructure:

* [promote](./infrastructure_promote_replica.md) - permanently promotes a replica
to be the new primary. NOTE: This should only be done once the old primary
has been taken offline permanently, else data loss may occur or infrastucture
may not be operational.

* [forget](./infrastructure_forget_replica.md) - performs required cleanup if a
replica goes offline permanently. Must be performed or PE infrastructure will
endlessly queue up syncs under the assumption replica is offline.

* [reinitialize replica](./infrastructure_reinitialize_replication.md) - resets
synchronization by dropping and recreating pglogical replicated databases (all
database except for puppetdb)

## HA state machine

You can configure HA with the above commands, but they need to be called in a
specific order to make sure state transitions are handled appropriately.

Outline of states and actions

```
Monolithic -- provision --> provisioned replica
Provisioned replica -- enable --> enabled replica
Enabled replica -- forget --> Monolithic
Enabled replica (original primary breaks, taken offline) -- promote --> promoted replica (monolithic with new primary)
```

State diagram
![HA state machine diagram](./HA_state_machine.svg)

### States in detail

How states are determined and recorded in PE is complex. We'll go through each
of them below.

#### #1: No HA (never configured it)
TODO:
* how to tell you've never configured it

#### #2: Provisioned a replica
This is the stage at which primary node software is installed on the
replica, and data from the MoM is copied over.
TODO:
* document provisioned replicas param
* document data replication details
* document steps taken, in what order, how to know when it's done

#### #3: Enabled a replica
This is the stage at which software components are reconfigured to be able to
point to the replica in case of a failure, when its data replication should be
complete.
TODO:
* document enabled replicas param
* document failover behavior?

#### #3 -> #1: No HA (forgot a replica)
When you 'forget' a replica, then you end up back in the original state.
TODO:
* document why necessary -- pglogical replication slots

#### #4: Read-only mode
This is the situation in which HA saves your butt: the original MoM is
erroring, unresponsive, or offline for whatever reason, but your Puppet
runs are still succeeding because the replica is able to serve all the necessary
information. However, everything besides PuppetDB is in read-only mode, and
things are slower since agents will make requests to the MoM first—which will
take a little time to error or time out—before using the replica.

#### #5: No HA (promoted a replica, haven't provisioned new one)
Promoting the replica to be the new MoM disables read-only mode and allows you
to make changes again. Ideally, this state would be indistinguishable from the
original state but there are a few differences.
TODO:
* document differences

## Multiple replicas
Currently possible, but unsupported/poorly tested. This is a future feature.

## Data replication
TODO: PDB, pglogical, and you
