# puppet infrastructure tune

#### Table of Contents

1. [Description - What the action does and why it is useful](#description)
1. [Usage - Command parameters and how to use them](#usage)
1. [Reference - How the action works and how to use its output](#reference)
1. [Limitations - Supported infrastructures](#limitations)

## Description

> The fault, dear Brutus, is not in our stars, but in our defaults, that we are under-allocating system resources.

This action outputs optimized settings for Puppet Enterprise services based upon available system resources.

## Usage

1. Run the `puppet infrastructure tune` action as root on the Primary Master.
1. Verify the optimized settings.
1. Add the optimized settings to Hiera.
1. Remove any duplicate settings from the Console.
1. Run `puppet agent -t` on each PE Infrastructure host to apply the optimized settings.

#### Parameters

##### `--common`

Extract common settings from node-specific settings when outputting optimized settings.

A common setting is one with a value that is identical on multiple hosts.
This option extracts and outputs common settings separately from node-specific settings, potentially reducing the number of node-specific settings.

##### `--compare`

Output a comparison of currently-defined and optimized settings.

##### `--current`

Output currently-defined settings, in JSON format.

Settings may be defined either in the Classifier (the Console) or in Hiera, with Classifier settings taking precedence over Hiera settings.
This option also identifies duplicate settings defined in both the Classifier and Hiera.
Best practice is to define settings in Hiera (preferred) or the Classifier, but not both.

##### `--debug`

Enable logging of debug information.

##### `--hiera DIRECTORY`

Output optimized settings to the specified directory, as YAML files for use in Hiera.

> Do not specify a directory in your Hiera hierarchy if that directory is managed by Code Manager. Instead: specify a temporary directory, verify the settings in resulting files, and merge them into the control repository that contains your Hiera data.

##### `--force`

Do not enforce minimum system requirements (4 CPU / 8 GB RAM) for PE Infrastructure hosts.

##### `--inventory FILE`

Use the specified YAML file to define PE Infrastructure hosts.

This eliminates a dependency upon PuppetDB to query facts and classes for PE Infrastructure hosts.

##### `--local`

Use the local system to define a monolithic master host.

This eliminates a dependency upon PuppetDB to query facts and classes for PE Infrastructure hosts, and is only useful after a clean install of a monolithic master host.

##### `--memory_per_jruby MB`

Amount of RAM to allocate for each Puppet Server JRuby.

##### `--memory_reserved_for_os MB`

Amount of RAM to reserve for the operating system and other services.

##### `--node CERTNAME`

Limit output to a single PE Infrastructure host.

##### `--use_current_memory_per_jruby`

Use currently-defined settings to determine `memory_per_jruby`.

## Reference

This command outputs optimized settings for PE services as follows.

1. Query PuppetDB for PE Infrastructure hosts (query for declared PE classes)
1. Identify PE Infrastructure type: Standard, Large, Extra Large (legacy: Split)
1. Query PuppetDB for CPU and RAM facts for each PE Infrastructure host (query for processors, memory)
1. Output settings for PE services for each PE Infrastructure host (as parameters for the declared PE classes)

### Output

By default, settings are output to STDOUT.

For example:

```shell
[root@master ~] puppet infrastructure tune
# Puppet Infrastructure Summary: Found a Monolithic Infrastructure

# Found 8 CPU(s) / 16384 MB RAM for Primary Master pe-master.puppetdebug.vlan
# Specify the following optimized settings in Hiera in nodes/pe-master.puppetdebug.vlan.yaml

---
puppet_enterprise::profile::database::shared_buffers: 4096MB
puppet_enterprise::puppetdb::command_processing_threads: 2
puppet_enterprise::master::puppetserver::jruby_max_active_instances: 5
puppet_enterprise::master::puppetserver::reserved_code_cache: 1024m
puppet_enterprise::profile::master::java_args:
  Xms: 3840m
  Xmx: 3840m
puppet_enterprise::profile::puppetdb::java_args:
  Xms: 1638m
  Xmx: 1638m
puppet_enterprise::profile::console::java_args:
  Xms: 768m
  Xmx: 768m
puppet_enterprise::profile::orchestrator::java_args:
  Xms: 768m
  Xmx: 768m

# CPU Summary: Total/Used/Free: 8/7/1 for pe-master.puppetdebug.vlan
# RAM Summary: Total/Used/Free: 16384/12134/4250 for pe-master.puppetdebug.vlan
# JVM Summary: Using 768 MB per Puppet Server JRuby for pe-master.puppetdebug.vlan
```

By default, this action outputs node-specific settings for use in node-specific YAML files in a node-specific Hiera hierarchy.

For example:

#### Hiera 3.x

```yaml
---
:hierarchy:
  - "nodes/%{trusted.certname}"
  - "common"
```

#### Hiera 5.x

```yaml
---
version: 5
hierarchy:
  - name: "Per-Node Data"
    path: "nodes/%{trusted.certname}.yaml"
  - name: "Common values"
    path: "common.yaml"
```

### Reference Links:

For more information, review:

* [PE Hardware Requirements](https://puppet.com/docs/pe/latest/installing/hardware_requirements.html)
* [PE Configuration](https://puppet.com/docs/pe/latest/configuring/config_intro.html)
* [PE Java Arguments](https://puppet.com/docs/pe/latest/configuring/config_java_args.html)
* [PE Puppetserver Configuration](https://puppet.com/docs/pe/latest/configuring/config_puppetserver.html)
* [PE Console Configuration](https://puppet.com/docs/pe/latest/configuring/config_console.html)
* [PE PuppetDB Configuration](https://puppet.com/docs/pe/latest/configuring/config_puppetdb.html)
* [PE Tuning Monolithic](https://puppet.com/docs/pe/latest/configuring/tuning_monolithic.html)
* [PE Puppetserver Tuning Guide](https://puppet.com/docs/puppetserver/latest/tuning_guide.html)
* [Hiera](https://puppet.com/docs/puppet/latest/hiera_intro.html)

## Limitations

### Infrastructure Support

Support is limited to the following infrastructures:

* Monolithic Master
* Monolithic Master with HA
* Monolithic Master with Compile Masters
* Monolithic Master with Compile Masters with HA
* Monolithic Master with Compile Masters with External PostgreSQL
* Monolithic Master with External PostgreSQL
* Split Infrastructure
* Split Infrastructure with Compile Masters
* Split Infrastructure with Compile Masters with External PostgreSQL
* Split Infrastructure with External PostgreSQL
