# SLES 11 has incompatibilities with the latest Java version being
# used on the primary, which causes zypper to fail to install the agent
# with an SSL error.  $use_repo should only be set to false to directly
# download and install the rpm on SLES 11.
define pe_repo::sles(
  $agent_version   = $facts['aio_agent_build'],
  $installer_build = $title,
  $pe_version      = $pe_repo::default_pe_build,
  $use_repo        = true,
  $fips,
  $os_name,
  $os_version,
  $os_arch,
) {
  include pe_repo

  File {
    ensure => file,
    mode   => '0644',
    owner  => 'root',
    group  => 'root',
  }

  # These variables are needed by this template
  $prefix = $pe_repo::prefix
  $master = $pe_repo::master
  $port = $settings::masterport
  $installer_build_parts = $installer_build.split('-')
  $short_platform_version = "${installer_build_parts[0]}${installer_build_parts[1]}"
  $arch = $installer_build_parts[2]

  file { "${pe_repo::public_dir}/${pe_version}/${installer_build}.bash":
    content => template('pe_repo/sles.bash.erb'),
  }

  $agent_version_sans_sha = split($agent_version, /\.g/)[0]
  pe_repo::repo { "${installer_build} ${pe_version}":
    agent_version   => $agent_version_sans_sha,
    installer_build => $installer_build,
    pe_version      => $pe_version,
    tarball_creates => "repodata",
    tarball_strip   => '5',
    fips            => $fips,
    os_arch         => $os_arch,
    os_name         => $os_name,
    os_version      => $os_version,
  }
}

