#### Table of Contents

1. [Overview](#overview)
2. [Module Description - What the module does and why it is useful](#module-description)
3. [Setup - The basics of getting started with pe_manager](#setup)
4. [Usage - Configuration options and additional functionality](#usage)
5. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
5. [Limitations - OS compatibility, etc.](#limitations)
6. [Development - Guide for contributing to the module](#development)

## Overview

The pe_manager module provides the `puppet infrastructure` face for managing Puppet
Enterprise installations, upgrades and high availability installations with
Puppet.  It relies on the
[puppetlabs-pe_install](../pe_install) to
provide the manifests for installation and upgrade, which in turn does its work
through the
[puppet_enterprise](../puppet_enterprise)
module.

## Module Description

This module extends Puppet with an *infrastructure* face providing a *configure*
action for idempotent installation/upgrade/configuration of a Puppet Enterprise
installation as described by the parameters in a pe.conf Hocon configuration
hiera file.

The face is based off of Reid Vandewiele's
[nimbus](https://github.com/puppetlabs/tse-module-nimbus) work.  It makes use
of `puppet apply` in a restricted environment (modulepath tied to
/opt/puppetlabs/server/data/environments/enterprise/modules, among other things) to ensure
that a PE node is in the state declared by the pe_install module.  How the
pe_install and puppet_enterprise modules apply to the node depends on
parameters set in the pe.conf hiera file, as located by
/etc/puppetlabs/enterprise/hiera.yaml (typically in
/etc/puppetlabs/enterprise/conf.d/pe.conf).

The pe.conf file is in Hocon format and consists of PE module parameters.
The base set of parameters which must be set are puppet_enterprise parameters
identifying master_host, puppetdb_host, console_host, etc.  The pe_install
module can then decide which puppet_enterprise profiles to apply, based on a
match of the $::certname fact with these settings.  The sample
[pe.conf](https://github.com/puppetlabs/pe-installer-shim/blob/2018.1.0-rc1/conf.d/pe.conf)
file in the
[pe-installer-shim](https://github.com/puppetlabs/pe-installer-shim) is
suitable for a monolithic install, and takes the shortcut of assigning
$certname to all the primary host settings.

There are protype convert and uninstall actions for the face in this module,
but they have not been completed.

## High Availability

Several additional actions have been added for High Availability, and are
detailed in the [HA Docs](doc/high_availability/HA_overview.md).

## Tune

The [Tune Action](doc/infrastructure_tune.md), added by Tom Kishel, can be used
to determine sane PE defaults for the hosts based on introspection of the
underlying hardware.

## Run

The `puppet infra run` action is a lightweight wrapper around a private Bolt
instance provided by the pe-installer package used to run PE management plans.

See `puppet infra run --help` for a list of available plans.

The plans themselves are in the
[enterprise_tasks](git@github.com:puppetlabs/enterprise_tasks) repository, and
also ship with pe-installer.

## Setup

The pe_manager infrastructure face cannot work in isolation.  It expects:

* modules installed in /opt/puppetlabs/server/data/environments/enterprise/modules
  * 2018.1.x+ PE modules (puppet-enterprise-modules, of which pe_manager is a part), but specifically:
    * pe_install
    * pe_infrastructure
* /etc/puppetlabs/enterprise/hiera.yaml

The simplest way to get pe_manager installed and configured on a PE node is to
use the [pe-installer-shim](https://github.com/puppetlabs/pe-installer-shim) to
install PE on that node. (Install a 2018.1+ PE tarball)

After that, you can reinvoke pe_manager by calling (as root)

    $ puppet infrastructure configure

Since $PATH is changed during the install `puppet infrastructure` may not be
available until you spawn a new shell.  [See Joshua's
comment.](https://tickets.puppetlabs.com/browse/PE-15117?focusedCommentId=311563&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-311563)

### External Subcommand

Because the pe-modules package installs pe_manager only in the enterprise
environmentpath (/opt/puppetlabs/server/data/environments), Puppet will not
find it automatically. This would require invoking `puppet infrastructure`
commands with --environmentpath and --environment overrides (for example:)

    $ puppet infrastructure configure --environmentpath /opt/puppetlabs/server/data/environments --environment enterprise

To simplify this, the pe_infrastructure module has an external Puppet
subcommand,
[puppet-infrastructure](https://github.com/puppetlabs/puppetlabs-pe_infrastructure/blob/irving/files/puppet-infrastructure)
which is installed into /opt/puppetlabs/bin. This subcommand takes care of
including the environmentpath and environment options, and Puppet will load
from it once it fails to find the face in its modulepath (see
[command_line.rb](https://github.com/puppetlabs/puppet/blob/5.3.3/lib/puppet/util/command_line.rb#L89-L92))

## Usage

The basics of installing/upgrading using pe_manager are wrapped by the
pe-installer-shim's
[puppet-enterprise-installer](https://github.com/puppetlabs/pe-installer-shim/blob/2016.2.x/puppet-enterprise-installer)
bootstrap script.

The pe_install and puppet_enterprise modules are intended to be idempotent.  So
you can reinvoke `puppet infrastructure configure` either to fix an issue that
occured during install or to revert configuration drift or update configuration
if pe.conf has been updated with new parameters.

    $ puppet infrastructure configure

Basic help is available with the '-h' flag.

## Reference

The two classes shipped with this module are used by the HA actions during 
promotion and reinitilization of replica. The are internal implementation
details of the faces themselves, and not intended for use in other catalogs.

## Limitations

The infrastructure face is intended for use on the core PE infrastructure nodes and
platforms.  So primary, database nodes for a supported PE primary platform.

Some HA actions are intended to be run on a replica (promote for example).

## Development

There is some spec coverage of the face in spec/unit.

Specs can be run as follows:

    $ bundle config specific_platform true # If not set, bundler will not pull in OSX/Linux specific gems
    $ bundle install
    $ bundle exec rake spec

If you encounter errors related to `cfpropertylist` when running specs on OSX,
try making sure that `bundle config specific_platform true` is set and then
re-run bundle install. That may solve that particular problem.

### Testing

Please see the testing information in the top level [README](../../README.md) on how to use Frankenbuilder and RSpec on your changes.

## Maintenance

Maintainers: Josh Partlow <joshua.partlow@puppetlabs.com>

Tickets: https://tickets.puppetlabs.com/browse/PE. Make sure to set component to 'PE Modules'.
