# Handles local installation of core PE infrastructure (primary, database)
# on the individual nodes given.
#
# Runs the tarball's boostrap-installer script, and then calls
# /opt/puppetlabs/installer/bin/meep install local
#
# For legacy cases, runs the tarball's puppet-enterprise-installer script.
#
# Assumes that the targets have a workdir variable set with a pe.conf prepared,
# and a pe_dir variable set that points to the location of the unpacked PE tarball
# on the target node.
#
# @param nodes
#   The nodes to install PE on.
# @param profile
#   The profile to apply to the node.
# @param legacy
#   True if the version of PE we are installing requires us to run
#   puppet-enterprise-installer.
# @param legacy_options
#   Relevant for upgrades with the puppet-enterprise-installer script.
plan enterprise_tasks::testing::run_installer(
  TargetSpec $nodes,
  Enum['all','ca'] $profile = 'all',
  Boolean $legacy = false,
  Struct[{
            non_interactive => Boolean,
            skip_pe_conf    => Boolean,
        }]
        $legacy_options = {
                              'non_interactive' => false,
                              'skip_pe_conf'    => false,
                            },
) {
  if $legacy {
    run_plan('enterprise_tasks::testing::run_legacy_installer',
      'nodes'           => $nodes,
      'non_interactive' => $legacy_options['non_interactive'],
      'skip_pe_conf'    => $legacy_options['skip_pe_conf'],
    )
  } else {
    get_targets($nodes).each |$target| {
      $workdir = $target.vars()['workdir']
      if $workdir =~ Undef {
        fail_plan("${target} did not have a workdir set, so we don't know the path to the pe.conf file.")
      }
      $pe_dir = $target.vars()['pe_dir']
      if $pe_dir =~ Undef {
        fail_plan("${target} did not have a pe_dir set, so we don't know the path to the PE tarball.")
      }

      run_task('enterprise_tasks::bootstrap_pe_installer',
        $target,
        'pe_tarball_dir' => $pe_dir,
      )
      run_task('enterprise_tasks::run_pe_admin',
        $target,
        'pe_tarball_dir' => $pe_dir,
        'pe_conf'        => "${workdir}/pe.conf",
        'profile'        => $profile,
      )
    }
  }
}
