#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require_relative '../lib/enterprise_tasks/puppet_helper.rb'
require 'open3'
require 'fileutils'

class BackupCerts < EnterpriseTaskHelper
  include EnterpriseTasks::PuppetHelper

  def task(pg_version: '11', **_kwargs)
    backup_dirs = if Gem.win_platform?
                    ['C:/ProgramData/PuppetLabs/puppet/etc/ssl']
                  else
                    # This should be the superset of directories that we'd want to back up.
                    # Directories that don't exist on the node will be skipped.
                    [
                      '/etc/puppetlabs/puppet/ssl',
                      '/etc/puppetlabs/puppetserver/ca',
                      '/etc/puppetlabs/orchestration-services/ssl',
                      '/opt/puppetlabs/server/data/console-services/certs',
                      '/etc/puppetlabs/puppetdb/ssl',
                      "/opt/puppetlabs/server/data/postgresql/#{pg_version}/data/certs",
                      '/opt/puppetlabs/server/data/host-action-collector/ssl',
                    ]
                  end

    cmd = [puppet_bin, 'config', 'print', 'certname']
    certname = Open3.capture2e(*cmd)[0].strip
    output = ''
    timestamp = Time.now.to_i
    backups = ''
    backup_dirs.each do |dir|
      timestamped_dir = "#{dir}_bak_#{timestamp}"
      next unless File.directory?(dir)
      FileUtils.cp_r(dir, timestamped_dir, preserve: true)
      backups += "#{timestamped_dir} "
      unless File.directory?(timestamped_dir)
        raise EnterpriseTaskHelper::Error.new("Backing up Puppet directory: #{dir} failed on host with certname #{certname}", 'puppetlabs.backup-certs/backup-failed', 'output' => output)
      end
    end

    result = { backups: backups }
    result.to_json
  end
end

BackupCerts.run if __FILE__ == $PROGRAM_NAME
