require 'net/http'
require 'uri'
require 'json'

Puppet::Functions.create_function('pe_repo::query_license_api') do
  dispatch :query_license_api do
  end

  # This function queries the Host-action-controller API on the primary Puppet Enterprise server.
  # It returns the HTTP response of the License endpoint.
  # https://github.com/puppetlabs/pe-host-action-collector/blob/main/doc/licence/api.md
  # @return [Net::HTTPResponse] The HTTP response from the license API.
  def query_license_api()
    begin
      primary_hostname = Facter.value(:fqdn)
      uri = URI.parse("https://#{primary_hostname}:8147/license/v1/current")
      client = Puppet.runtime[:http]
      response = client.get(uri)
      if response.success?
        JSON.parse(response.body)
      else
        {}
      end
    rescue Puppet::HTTP::HTTPError => e
      Puppet.warning("1. Failed to get license: #{e.message}")
      {}
    end
  end
end