function puppet_enterprise::calculate_database_maint_autovac_work_mem (
  Enum['maintenance','autovacuum'] $type,
  Integer                          $autovacuum_max_workers = 1,
) >> String {
  $maint_work_mem_base = Integer($facts['memory']['system']['total_bytes']) / 1024 / 1024 / 8
  $autovac_work_mem    = pe_min($maint_work_mem_base / $autovacuum_max_workers, 2048)
  $maint_work_mem      = pe_min($maint_work_mem_base, 2048)

  $out = $type ? {
    'autovacuum'  => "${autovac_work_mem}MB",
    'maintenance' => "${maint_work_mem}MB",
  }
}
