# puppet_enterprise::postgresql::remove
# =====================================
#
# Ensures that old format pe-postgresql packages are removed:
#
#   pe-postgresql
#   pe-postgresql-server
#   pe-postgresql-contrib
#   pe-postgresql-devel
#   pe-postgresql-pglogical
#   pe-postgresql-pgrepack
#
# This makes way for clean upgrades to pe-postgresql96 or pe-postgresql11.
#
# The pe-postgresql96 and 11 packages obsolete their counterparts, allowing the
# package managers to handle this automatically, however with yum this was resulting
# in both pe-postgresql96* and pe-postgresql11* being installed, which should only
# happen if we're intentionally installing both sets to assist in migration
# from 9.6 to 11.
class puppet_enterprise::postgresql::remove {
  package { 'pe-postgresql-pglogical':
    ensure => absent,
  }
  -> package { 'pe-postgresql-pgrepack':
    ensure => absent,
  }
  -> package { 'pe-postgresql-contrib':
    ensure => absent,
  }
  -> package { 'pe-postgresql-devel':
    ensure => absent,
  }
  -> package { 'pe-postgresql-server':
    ensure => absent,
  }
  -> package { 'pe-postgresql':
    ensure => absent,
  }
}
