# frozen_string_literal: true

# THIS IS A PE SPECIFIC IMPLEMENTATION OF write_file: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/boltlib/lib/puppet/functions/write_file.rb
#
# write_file for plans-in-PE will return an error since it is not needed in the current iteration
# of plans in PE.
Puppet::Functions.create_function(:write_file) do
  # @param targets A pattern identifying zero or more targets. See {get_targets} for accepted patterns.
  # @param content File content to write.
  # @param destination An absolute path on the target(s).
  # @option options [Boolean] _catch_errors Whether to catch raised errors.
  # @option options [String] _run_as User to run as using privilege escalation.
  # @return A list of results, one entry per target.
  # @example Write a file to a target
  #   $content = 'Hello, world!'
  #   write_file($targets, $content, '/Users/me/hello.txt')
  dispatch :write_file do
    required_param 'String', :content
    required_param 'String[1]', :destination
    required_param 'Boltlib::TargetSpec', :targets
    optional_param 'Hash[String[1], Any]', :options
    return_type 'ResultSet'
  end

  def write_file(content, destination, target_spec, options = {})
    unless Puppet[:tasks]
      raise Puppet::ParseErrorWithIssue
        .from_issue_and_stack(Bolt::PAL::Issues::PLAN_OPERATION_NOT_SUPPORTED_WHEN_COMPILING, action: 'write_file')
    end
    # TODO: https://tickets.puppetlabs.com/browse/PE-29107
    raise Puppet::Error, "write_file is currently not supported in PE plans"
  end
end
