# @summary This function is used to determine the platform determined by os name.
#
# @param name The name of the platform.
#
# @return [String] The platform name.
#
# @example
#   enterprise_platform::platform('debian-7-x86_64')
#   Would return: 'debian'
Puppet::Functions.create_function('enterprise_tasks::platform') do
  dispatch :platform do
    param 'String', :name
    return_type 'Any'
  end

  def platform(name)
    case name
    when %r{^aix}
      'aix'
    when %r{^amazon|^el|^fedora|^redhatfips}
      'el'
    when %r{^debian|^ubuntu}
      'debian'
    when %r{^osx}
      'osx'
    when %r{^sles}
      'sles'
    when %r{^solaris}
      'sol11'
    when %r{^windows}
      'windows'
    end
  end
end
