require_relative '../pe_install/pe_postgresql_info.rb'
# If and only if we are on a PE server node (where pe-puppet-enterprise-release
# package is installed and the pe_server_version fact returns
# /opt/puppetlabs/server/pe_version), lookup to see if there is an install
# version for pe-postgresql-server.
Facter.add("pe_postgresql_info") do
  # avoids additional package lookups on every agent node
  confine(:pe_server_version) { |value| !value.empty? }

  setcode do
    pvl = PEPostgresqlInfo.new
    pvl.to_hash
  end
end
