## [Release 3.8.0] - 2025-09-09

Feature release of the Support Script.

### Features

  - Added `pe.pe-workflow-service`.

  - Support script now collects certificate and inventory data
    from the Puppet Server CA.


## [Release 3.7.0] - 2025-06-10

Feature release of the Support Script.

### Features

  - Added `pe.infra-assistant`.

  - Support script now collects logs created by apt, dnf, and zypper
    package managers.


## [Release 3.6.0] - 2025-05-09

Feature release of the Support Script.

### Features

  - Add test coverage for Ubuntu 24.04

  - Add test coverage for Amazon Linux 2023

  - Support script now collects system-wide logs from `journalctl`


## [Release 3.5.0] - 2024-12-06

Feature release of the Support Script.

### Features

  - Added `pe.patching-service`.

  - The `puppetserver.events` check is now opt-in as it can
    process a large amount of data.

### Bug Fixes

  - Fix collection of PuppetDB certificate-allowlist

  - Tolerate race conditions when reading `/proc/*/exe`
    where the process being inspected has exited.


## [Release 3.4.0] - 2024-04-19

Feature release of the Support Script.

### Features

  - Added support for Puppet 8 and Ruby 3.

  - Added support and test coverage for Ubuntu 22.04.

  - Added support and test coverage for RedHat 9.

  - Improved test coverage for Ubuntu 20.04 and SLES 15.

  - `puppet.status` now includes `--timing` output from Facter.

  - `pe.orchestration.config` now includes `file-sync.conf`
    for Orchestrator.

  - `system.status` now includes zero-valued counters in `nstat` output.

  - `pe.orchestration` now gathers diagnostics for the `pe-plan-runner`
    service.

  - Added `pe.host-action-collector`.

  - Improved `pe.postgres.status` collection of database table sizes.

### Bug Fixes

  - `*.status` checks no longer attempt to collect data from
    `/proc` when services are stopped or process IDs don't
    exist. This resolves exceptions that would terminate
    the checks early.

  - `puppet.status` no longer misses package version numbers on Ubuntu.

  - `pe.console.status` can retrieve LDAP configuration from PE 2023.

### Removals

  - `pe.postgres` no longer supports Postgres 9.6.


## [Release 3.3.1] - 2022-12-30

Bugfix release of the Support Script.

### Bug Fixes

  - Fixed instances where external commands were allowed to execute
    with an indefinite timeout. All diagnostic commands should now
    time out if they do not complete within 5 minutes.

  - Support script now collects pg_controldata output from
    PostgreSQL 14.

  - Removed an errant newline in a URL that caused requests to the
    PuppetDB API to fail.

  - Fixed a column reference in a SQL query that became ambiguous
    when run under PostgreSQL 14 resulting in no output returned
    for `db_relation_sizes_by_table.txt`.

  - Diagnostic commands that exit with a non-zero code now have
    `stderr` output logged at DEBUG level, which is recorded
    in `support_script_log.jsonl`.


## [Release 3.3.0] - 2022-10-04

Feature release of the Support Script.

### Features

  - The support script now collects `/proc/*/smaps` for all processes
    belonging to each Puppet service in order to present a snapshot
    of memory consumption.


## [Release 3.2.0] - 2022-08-11

Feature release of the Support Script.

### Bug Fixes

  - The Ruby support script now cleans up output directories when
    interrupted via CTRL-C.

  - The Ruby support script timeout for output archive generation has
    been doubled to 10 minutes.

### Features

  - The Windows support script includes NSSM event logs for
    the `pxp-agent` service.

  - The Ruby support script allows the use of glob expressions
    for the `--enable`, `--disable`, and `--only` flags.
    For example: `--only '*.logs'`.


## [Release 3.1.0] - 2022-04-28

Feature release of the Support Script.

### Bug Fixes

  - The `pg_replication_origin_status` diagnostic collected on replicas was
    removed as it produced misleading data. Postgres replication lag can
    only be measured from the primary.

  - Invocations of `iptables` use the `-n` flag so that port numbers are
    always shown.

  - The Windows support script properly merges `facter` stderr into stdout.

  - The support script now executes subcommands with the null file
    open on stdin if no input data was provided. This avoids issues
    with commands that fail if stdin is closed.

### Features

  - The support script collects the host certificate, CA certificate,
    and certificate revocation list.

  - The support script collects a copy of events recorded by the
    PE analytics service.

  - The support script collects package pins from apt, yum, and zypper.

  - Add Ubuntu 20.04 and SLES 15 as supported PE infrastructure platforms.


## [Release 3.0.0] - 2021-10-12

Major release of the Support Script.

### Breaking Changes

  - The Ruby support script is now run by default. This version of the script
    was available starting in release 2.9.0 by passing the `--v3` flag. This
    flag is now the default and the old Bash script can be accessed by passing
    a new `--v1` flag.

  - The Bash script is in maintenance mode and deprecated pending removal
    in a future release.

  - The `puppet` scope has been re-named to `puppet-agent`.

  - The default cut-off age for log files and metrics has been reduced
    from 14 days to 7 days.

  - The minimum supported PE version has been updated to 2019.8 or newer
    and support for RedHat 6, SLES 11, and Ubuntu 14.04 and 16.04 has been
    dropped. The script will likely run against older PE versions and operating
    systems, especially when `--v1` is used, but test coverage is no longer present.

### Bug Fixes

  - Process tree collection via `ps -e f` is now properly collected.

  - Diagnostics gathered from local PE service APIs no longer fail
    due to newlines at the end of paths to certificates and keys.

  - Directories named `.snapshot`, `.snapshots`, and `.backup` are
    no longer traversed by diagnostics that walk the filesystem.
    This prevents excessive resource usage when certain backup
    systems are in use.

  - Log messages generated by PE services that JournalD does not
    tag with the service name are no longer excluded from log collection.

  - The timeout of the PowerShell support script was doubled from
    120 seconds to 240 seconds to account for potential network timeouts.

  - Requests to local PE APIs are excluded from routing through proxies.

### Features

  - The Ruby support script now captures a snapshot from the
    Puppet Server analytics API.

  - The Ruby support script now captures the output of
    `systemctl list-timers`.

  - The Ruby support script now captures logs and status from
    maintenance jobs set up by the `puppet_metrics_collector`
    and `pe_databases` modules.

### Removals

  - The Windows support script no longer collects MCollective diagnostics.
    This decreases runtime by several minutes by skipping checks that would
    wait to be canceled by network timeouts.


## [Release 2.16.0] - 2021-02-09

Feature release of the Support Script.

### Features

  - Windows support script captures logs created by PE Patch Management.

  - Support Script v3 collects vSphere metrics produced by the
    `puppetlabs-puppet_metrics_collector` module, version 6.2.0 and newer,
    as part of the `system.metrics` check.

  - Support Script v3 collects PostgreSQL metrics produced by the
    `puppetlabs-puppet_metrics_collector` module, version 6.2.0 and newer,
    as part of the `pe.postgres.metrics` check.

  - GPG key used to encrypt Support Script output has been updated.


## [Release 2.15.0] - 2020-10-20

Feature and bugfix release of the Support Script.

### Features

  - Support Script v3 captures logs generated by the pe_databases module.

  - Support Script v3 captures TCP timer information from `netstat` output.

  - Support Script v3 sorts `db_relation_sizes_by_table.txt` by total
    table size.

  - Support Script v3 sorts `pg_stat_activity` output by transaction
    start date.

  - Support Script v3 collects output from Postgres `pg_locks`.

  - Support Script v3 collects output from Postgres `pg_stat_bgwriter`.

  - Support Script v3 collects output from Postgres `pg_replication_origin_status`.

  - Support Script v3 collects output from Postgres `pg_controldata` tool.

  - Support Script v3 includes replication lag in diagnostics collected
    `pg_replication_slots`.

### Bug Fixes

  - Fixed an issue where Support Script v3 did not capture Postgres
    logs for PE 2018.1.

### Removals

  - Support script no longer collects `db_relation_sizes.txt` or
    `db_total_relation_sizes.txt`. These have been superseded by
    information collected in `db_relation_sizes_by_table.txt`.


## [Release 2.14.0] - 2020-07-15


Feature and bugfix release of the Support Script.

### Features

  - Support Script v3 now captures archived SAR metrics

  - Support Script v3 now captures `puppet_metrics_collector` metrics
    for ace-server, bolt-server, and the operating system

  - Support Script v3 now captures kernel settings from `sysctl -a`

  - Support Script v3 now captures TCP statistics from `nstat -a`

  - Support Script v3 now captures a list of Postgres extensions
    installed in each database

  - Support Script v3 now captures Postgres database, table,
    and index statistics

### Bug Fixes

  - Support Script v3 now properly merges `stderr` into `stdout` from
    diagnostic commands


## [Release 2.13.2] - 2020-04-03

Bugfix release of the Support Script.

### Bug Fixes

  - Ruby support script now collects service configuration from `/etc/default`
    and `/etc/sysconfig`.

  - Various and sundry fixes and improvements to documentation and test suites.


## [Release 2.13.1] - 2020-01-13

Bugfix release of the Support Script.

### Bug Fixes

  - Ruby support script now applies `gzip` compression to large output files.

  - Ruby support script no longer prints exit code to `stdout`.

  - Ruby support script now collects the size of Postgres TOAST tables.

  - Ruby support script now runs on RedHat variants such as Oracle Enterprise Linux
    and Scientific Linux.

  - Ruby support script responds to Ctrl-C, Ctrl-\, and SIGTERM.


## [Release 2.13.0] - 2019-10-16

### Summary

Feature and bugfix release of the Support Script.

### Features

  - Support for PE 2019.2

  - Support for RedHat 7 FIPS masters

  - Large re-write of the `--v3` Ruby version of the support script.
    This updated script groups diagnostics into scopes centered around
    PE Services that can be toggled on and off with the new `--enable`,
    `--disable`, and `--only` flags.


### Bug Fixes

  - The bash version of the support script properly collects disk space
    data from Postgres 11


## [Release 2.12.0] - 2019-07-17

### Summary

Feature and bugfix release of the Support Script.

### Features

  - Configuration and log files for the PE 2019.1 `pe-ace-server` service
    are collected from `/etc/puppetlabs/ace-server/conf.d` and from
    `/var/log/puppetlabs/ace-server`.

  - The size of the filebucket upload directory, `/opt/puppetlabs/server/data/puppetserver/bucket`
    is collected.

  - The `dnf.conf` file is collected on RedHat 8 systems.

  - Human-readable date stamps are added to `dmesg` output when available.

### Bug Fixes

  - The Ruby version of the support script now properly collects `gem list`
    output.


## [Release 2.11.0] - 2019-04-17

### Summary

Feature and bugfix release of the Support Script.

### Features

  - The Ruby support script now has an `--upload` option that uploads results
    to SFTP servers hosted by Puppet Inc. Requires the `--v3` flag to be
    passed and a value to be specified for the `--ticket` flag.

  - The support script now collects the output of `puppet infrastructure tune`.

  - The support script now collects process information from `/proc` for each
    PE service.

  - The support script now collects information from `/sys/fs/cgroup` for each
    PE service.

  - The support script now collects the output of `systemctl status` for each
    PE service.

  - The support script now supports RedHat 8 operating systems.

### Bug Fixes

  - The support script no longer creates a login shell when switching users
    to run diagnostics.


## [Release 2.10.0] - 2019-01-15

### Summary

Feature and bugfix release of the Support Script.

### Features

  - The support script now gathers node activity counts from the
    PE Orchestration Service.

  - Windows event logs are now captured in CSV format and include
    timestamps.

### Bug Fixes

  - The output archives of the PowerShell and Ruby support scripts
    now match the naming convention used by the Bash script.


## [Release 2.9.1] - 2018-10-24

### Summary

Bugfix release of the Support Script.

### Bug Fixes

  - The `--log-age` flag is used to limit the age of metrics data collected
    from /opt/puppetlabs. This further reduces the size of support script
    archives by only collecting 14 days worth of metrics data.

  - The support script now consults `/etc/os-release` when detecting the
    which OS it is executing on before falling back to the `lsb_release`
    command or platform specific release files.

  - LDAP connection settings are collected directly from console-services.
    Previously, these were selected from the database, which required the
    script to be run on the DB node of a split install.

  - The script no longer calls `puppet master --configprint` to discover
    modulepath as this command has been removed from PE 2019.0.


## [Release 2.9.0] - 2018-09-25

### Summary

Feature and bugfix release of the Support Script.

### Features

  - Postgres HA replication status is collected from `pg_replication_slots`
    and `pg_stat_replication`.

  - Configuration and log files for the PE 2019.0 `pe-bolt-server` service
    are collected from `/etc/puppetlabs/bolt-server/conf.d` and from
    `/var/log/puppetlabs/bolt-server`.

  - On PE 2019.0 and newer, the `puppetserver ca` command is used instead
    of `puppet cert` to list issued certificates.

  - Windows agents now receive a `puppet-enterprise-support.ps1` PowerShell
    script that performs basic checks of agent services and gathers logs.

  - New Ruby version of the support script that can be selected by passing
    the `--v3` flag to `puppet enterprise support`. This feature is under
    development and the regular script should be preferred for production use.

### Bug Fixes

  - Remove the check for `puppet module changes` on modules bundled with PE.
    This check has terrible performace, is duplicated by the validation output
    from the pe-modules package, and fails on PE 2019.0 as the required
    checksums.json files are no longer present.

  - Test suite updates for PE 2019.0 and Puppet 6.


## [Release 2.8.0] - 2018-07-17

### Summary

Feature and bugfix release of the Support Script bundled with PE 2017.3.9
and PE 2018.1.3. See release notes for version 1.9.1 for a list of bugfixes.

### Features

  - Added support for Ubuntu 18.04.

  - Support script now collects the  output of `puppet infrastructure status`
    if the client-tools package is installed and configured. This is useful
    for checking the state of a HA deployment along with other infrastructure
    nodes hosting PE services.


## [Release 2.7.0] - 2018-04-13

### Summary

Feature and bugfix release of the Support Script bundled with PE 2017.3.6,
2017.3.8, 2018.1.0, and 2018.1.2. See release notes for version 1.9.0 for a
list of improvements and bugfixes.


## Release 2.6.0

### Summary

Feature and bugfix release of the Support Script bundled with PE 2017.2.5 and
PE 2017.3.2, PE 2017.3.3, PE 2017.3.4, and PE 2017.3.5. See release notes for
version 1.8.0 for a list of improvements and bugfixes.


## Release 2.5.0

### Summary

Feature release of the Support Script bundled with PE 2017.2.4 and PE 2017.3.0.
See release notes for version 1.7.0 for a list of improvements and bugfixes.


## Release 2.4.0

### Summary

Feature release of the Support Script bundled with PE 2017.2.3. See release
notes for version 1.6.0 for a list of improvements and bugfixes.


## Release 2.3.0

### Summary

Feature release of the Support Script bundled with PE 2017.2.2. See release
notes for version 1.5.0 for a list of improvements and bugfixes.


## Release 2.2.0

### Summary

Feature release of the Support Script bundled with PE 2017.2.1.

### Features

  - A list of active nodes is gathered from the Orchestrator inventory
    API along with the PuppetDB nodes dataset.

  - All improvements and bugfixes from version 1.4.0.


## Release 2.1.0

### Summary

Feature release of the Support Script bundled with PE 2016.5.2 and 2017.1.0.

### Features

  - All improvements and bugfixes from version 1.3.0.

### Bug Fixes

  - Support script help now includes a note that some old enterprise
    subcommands moved to the puppet infrastructure command.


## Release 2.0.0

### Summary

Major release of the Support Script bundled with PE 2016.5.0.

### Features

  - The support script is now distributed to agent nodes via pluginsync.
    This is made possible by changes in PE 2016.5.0 which migrated other PE
    modules to the `puppet infrastructure` subcommand, which allows the
    support script to take sole ownership of the `puppet enterprise`
    subcommand.

  - All improvements and bugfixes from version 1.2.0.

### Breaking Changes

  - This version of the module requires PE 2016.5.0 or newer.

  - In order to support pluginsync, the support script has moved from:

      files/puppet-enterprise-support

    to:

      lib/puppet_x/puppetlabs/support_script/v1/puppet-enterprise-support.sh


## [Release 1.9.4] - 2018-10-24

### Summary

Bugfix release of the Support Script.

### Bug Fixes

  - Minor bugfix for a test that broke due to changes in 1.9.3.


## [Release 1.9.3] - 2018-10-24

### Summary

Bugfix release of the Support Script.

### Bug Fixes

  - The `--log-age` flag is used to limit the age of metrics data collected
    from /opt/puppetlabs. This further reduces the size of support script
    archives by only collecting 14 days worth of metrics data.


## [Release 1.9.2] - 2018-09-25

### Summary

Bugfix release of the Support Script.

### Bug Fixes

  - Remove the check for `puppet module changes` on modules bundled with PE.
    This check has terrible performace, is duplicated by the validation output
    from the pe-modules package, and fails on PE 2019.0 as the required
    checksums.json files are no longer present.


## [Release 1.9.1] - 2018-07-16

### Summary

Bugfix release of the Support Script bundled with PE 2016.4.14. This version is
functionally identical to 1.9.0, all fixes are for the test suite.


### Bug Fixes

  - Support script acceptance tests updated to use Puppet 4.10 and to respect
    the GEM_SOURCE environment variable.


## [Release 1.9.0] - 2018-04-13

### Summary

Feature and bugfix release of the Support Script bundled with PE 2016.4.11,
and 2016.4.13.

### Features

  - Support Script captures metrics from the `puppet/puppet_metrics_collector`
    module.

  - Support Script captures the contents of the `pg_stat_activity` table
    which shows all DB connections and what they are doing.

  - Support script captures on-disk sizes of database tables when the
    database service is stopped.

  - Support script captures a list of modules installed in each environment.

  - Support script now accepts an `--encrypt` flag that causes the output
    tarball to be encrypted using GPG.

  - Support script now accepts a `--log-age` flag that can be used to limit the
    amount of log data collected. This flag accepts an integer which specifies
    the maximum age in days for collecting logs. The string "all" may also be
    passed to enable collection of all logs.

### Bug Fixes

  - Support script no longer fails when running on SLES 12.2 if the
    `lsb-release` package is installed.


## Release 1.8.0

### Summary

Feature and bugfix release of the Support Script bundled with PE 2016.4.9
and PE 2016.4.10.

### Features

  - Support script collects logs left by `pg_upgrade` if Postgresql
    migration fails.

  - The disk space used by r10k caches and File Sync repositories is
    measured and reported to `resources/`.

  - The output of `find -ls` diagnostics is piped through gzip to reduce
    space consumed by the support script during data collection.

### Bug Fixes

  - The check for free disk space no longer parses `df` output in a
    mannner that is sensitive to the OS locale.

  - Support script can collect Postgres configuration when multiple
    `PG_DATA` directories are present due to a migration.


## Release 1.7.0

### Summary

Feature release of the Support Script bundled with PE 2016.4.8.

### Features

  - rpm and deb verification functions are to report difference between
    installed files and PE packages.

  - Output is gathered from the PuppetDB /status endpoint.


## Release 1.6.0

### Summary

Feature release of the Support Script bundled with PE 2016.4.7.

### Features

  - The `--dir` flag may be used to select a directory where support data is
    gathered and the final archive produced.

  - The `--classifier` flag may be passed to gather a dump of the PE Classifier
    groups.


## Release 1.5.0

### Summary

Feature release of the Support Script bundled with PE 2016.4.6.

### Features

  - Information on installed modules is now captured in YAML format.

  - Output from dmesg is captured along with system logs.

  - Disk space checks now take the size of log and metrics data
    into account.

  - Package manager configuration related to PE is now captured.

### Removals

  - Ubuntu 12.04 has been dropped from the test matrices. This follows the
    removal of 12.04 as a supported platform in PE 2016.4.5.

### Bug Fixes

  - Debug logs have been restored to Facter output.


## Release 1.4.0

### Summary

Feature release of the Support Script bundled with PE 2016.4.5.

### Features

  - The `puppet enterprise support` command now takes an optional `--ticket`
    flag that can be used to add a ticket number to the output filename
    and metadata.

  - Per-environment environment.conf and hiera.yaml files are now captured
    to aid with the troubleshooting of directory environment settings and
    Hiera 4/Hiera 5 features.

  - The facter.conf file is now collected along with other items from
    /etc/puppetlabs.

### Bug Fixes

  - Service status is now captured on OS versions that use systemd instead of
    just RedHat SysV init.

  - The puppet-agent package is now included in queries for the status
    of PE packages.


## Release 1.3.0

### Summary

Feature release of the Support Script bundled with PE 2016.4.3.

### Features

  - Support script output now contains a couple of additional symlinks that
    add compatibility with the SOScleaner tool. This tool can obfuscate
    hostname and IP information from Support Script tarballs.

  - Logs for PE services are collected from journalctl when available.

  - Gems installed via Puppet ruby or Puppetserver JRuby are listed along
    with version numbers.

  - The puppet log directory has been added to `find -ls` output.

  - ps stats now capture %cpu and %mem.

  - A DB query for thundering agent herds is run if PE Postgres is installed.

  - The output of the Orchestration Services status/ endpoint is collected.

  - Metrics produced by the pe\_metric\_curl\_cron\_jobs module are collected
    if available.

  - Additional configuration files are collected from PE Postgres along with
    the runtime values of Postgres settings.

### Bug Fixes

  - Support script archive creation has been updated to use one pipelined
    command instead of two separate commands. This reduces the amount of
    temporary disk space needed to create the final output.


## Release 1.2.0

### Summary

Feature release of the Support Script. Not included in any PE release.

### Features

  - Support Script gathers MCollective peadmin client configuration and logs
    from: /var/lib/peadmin

  - Support Script gathers PostgreSQL settings from:

      /opt/puppetlabs/server/data/postgresql/<version>/data/postgresql.conf

### Bug Fixes

  - A one minute timeout has been added to the check that gathers output
    from the PuppetDB summary-stats endpoint. For large databases, this
    operation can take tens of minutes.

  - Support script checks against PE server components are now conditional
    on the packages that provide those components being installed.


## Release 1.1.0

### Summary

Feature release of the Support Script bundled with PE 2016.4.0.

### Features

  - Support Script gathers output from the Puppet Server `status/v1/services`
    endpoint at debug level. This information is useful for troubleshooting
    Puppet Server performance issues.

  - Support Script gathers output from the Puppet Server `puppet/v3/environments`
    endpoint. This information is useful for troubleshooting modulepath and
    class synchronization issues.

### Bug Fixes

  - R10k checks now use the proper configuration file if Code Manager is enabled.


## Release 1.0.0

### Summary

First major release of the Support Script as a stand-alone module. This version
was bundled with PE 2016.2.0 with support for diagnosing PE infrastructure
installations, not agents.

### Features
  - Support Script extracted from the legacy PE installer repository and
    available as a stand-alone module. Script functionality is accessed through
    a new Puppet subcommand: `puppet enterprise support`

  - Support script archives now include the platform hostname and archive
    datestamps are in UTC. A `metadata.json` file has been added to enable
    automated parsing of support script contents.

  - The scope of configuration files gathered from `/etc/puppetlabs` has been
    clearly defined and sanitization of sensitive data has been improved.

  - Multiple small cleanups of diagnostic functions.

### Bug Fixes
  - Console status check timeout has been increased from 5 seconds to 60
    seconds.


[Release 3.8.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.7.0...3.8.0
[Release 3.7.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.6.0...3.7.0
[Release 3.6.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.5.0...3.6.0
[Release 3.5.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.4.0...3.5.0
[Release 3.4.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.3.1...3.4.0
[Release 3.3.1]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.3.0...3.3.1
[Release 3.3.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.2.0...3.3.0
[Release 3.2.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.1.0...3.2.0
[Release 3.1.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/3.0.0...3.1.0
[Release 3.0.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.16.0...3.0.0
[Release 2.16.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.15.0...2.16.0
[Release 2.15.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.14.0...2.15.0
[Release 2.14.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.13.2...2.14.0
[Release 2.13.2]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.13.1...2.13.2
[Release 2.13.1]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.13.0...2.13.1
[Release 2.13.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.12.0...2.13.0
[Release 2.12.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.11.0...2.12.0
[Release 2.11.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.10.0...2.11.0
[Release 2.10.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.9.1...2.10.0
[Release 2.9.1]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.9.0...2.9.1
[Release 2.9.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.8.0...2.9.0
[Release 2.8.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/2.7.0...2.8.0
[Release 2.7.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/5d0c9ba...2.7.0
[Release 1.9.4]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/1.9.3...1.9.4
[Release 1.9.3]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/1.9.2...1.9.3
[Release 1.9.2]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/1.9.1...1.9.2
[Release 1.9.1]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/1.9.0...1.9.1
[Release 1.9.0]: https://github.com/puppetlabs/puppetlabs-pe_support_script/compare/c01f3b9...1.9.0
