require 'pe_backup_tools/utils'
module PeBackupTools
  module Utils
    # This module provides a client for the analytics service in PE
    module AnalyticsClient
      def self.http_get_or_nil(url, cert_conf)
        PeBackupTools::Utils.get_response(url, cert_conf)
      # Swallow all the errors from Net::HTTP we can come up with
      rescue RuntimeError, Timeout::Error, Errno::EINVAL, Errno::ECONNREFUSED, Errno::ECONNRESET, EOFError, Net::HTTPBadResponse, Net::HTTPHeaderSyntaxError, Net::ProtocolError => _e
        return nil
      end

      def self.entrypoint(url, cert_conf)
        response = http_get_or_nil(url, cert_conf)
        JSON.parse(response.body) if response && response.body
      end

      def self.send_command(url, cert_conf, command_name, payload)
        # TODO: Log errors connecting to the analytics service
        entrypoint_data = entrypoint(url, cert_conf)
        if entrypoint_data
          commands = entrypoint_data['commands']
          command = commands[command_name] if commands
          command_url = command['id'] if command
          request_body = JSON.generate(payload)
          begin
            response = PeBackupTools::Utils.post_response(command_url, cert_conf, request_body)
            JSON.parse(response.body) if response && response.body
          rescue RuntimeError => _e
            # TODO: Log error about connecting to command_url
            return nil
          end
        end
      end

      def self.store_snapshot(url, cert_conf, fields)
        send_command(url, cert_conf, 'snapshot', fields: fields)
      end

      def self.store_event(url, cert_conf, event, metadata)
        send_command(url, cert_conf, 'event', event: event, metadata: metadata)
      end
    end
  end
end
