#pragma once

#include <leatherman/curl/client.hpp>
#include <leatherman/curl/request.hpp>
#include <leatherman/locale/locale.hpp>
#include <leatherman/json_container/json_container.hpp>

#include <boost/optional.hpp>

namespace puppet_access {
namespace request {

leatherman::curl::response post_token_request(leatherman::curl::client& client,
                                              const leatherman::curl::request& request);

std::string request_token(leatherman::curl::client& client,
                          const std::string& url,
                          const std::string& user,
                          const std::string& password,
                          const boost::optional<std::string>& lifetime);

leatherman::curl::request build_token_request(const std::string& url,
                                              const std::string& user,
                                              const std::string& password,
                                              const boost::optional<std::string>& lifetime);

std::string parse_token_body(const std::string& body);

std::string parse_token_response(const leatherman::curl::response& response);

void validate_response(const leatherman::curl::response& response);

struct error_response {
    std::string kind;
    std::string msg;
    const std::string& body;

    error_response(const std::string& json_body) : body(json_body) {
        try {
            leatherman::json_container::JsonContainer error(json_body);
            kind = error.get<std::string>("kind");
            msg = error.get<std::string>("msg");
        } catch(const leatherman::json_container::data_parse_error&) {
        } catch(const leatherman::json_container::data_key_error&) {}
    }

    std::string to_string() const {
        if (kind.empty() || msg.empty()) {
            // LOCALE: {1} is the body of an HTTP response.
            return leatherman::locale::translate("Unknown error.")
                + " " + leatherman::locale::format("The response is: {1}", body);
        } else {
            return kind + ": " + msg;
        }
    }
};
}  // namespace request
}  // namespace puppet_access
