#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require_relative '../lib/enterprise_tasks/puppet_helper.rb'
require 'open3'

class SetPuppetConfigSetting < EnterpriseTaskHelper
  include EnterpriseTasks::PuppetHelper

  def task(setting:, value:, section: 'main', **_kwargs)
    cmd = [puppet_bin, 'config', 'set', setting, value, '--section', section]
    result, status = Open3.capture2e(*cmd)
    raise EnterpriseTaskHelper::Error.new("Error running #{cmd.join(' ')}", 'puppetlabs.set-puppet-config-setting', 'output' => result) if !status.exitstatus.zero?
    result = { _output: result.chomp }
    result.to_json
  end
end

SetPuppetConfigSetting.run if __FILE__ == $PROGRAM_NAME
