# puppet infrastructure provision replica

## MAN PAGE

```
USAGE: puppet infrastructure provision [--token-file PATH]
[--force]
[--streaming]
replica <node_certname>

DESCRIPTION:
Provisions a new replica node based on the primary master. The replica node
duplicates services and components from the master. The node provided must be a
Puppet agent, but not another Puppet Enteprise infrastructure node (for
example, you cannot provide an existing compile master as an argument to this
command).
You can create a single replica of your master. If you already have a replica
and wish to replace it, take the old replica offline and run `puppet
infrastructure forget <NODE NAME>`. You can then provision a new
replica.

REQUIREMENTS:
  - An agent node to provision the replica on, running the same platform as
    your primary master. It must not already be an infrastructure node.
  - You must use the Code Manager workflow to deploy your code. Code Manager
    must be running and you must have deployed code at least once.
  - A valid token that has permission to run the Puppet agent with
    orchestrator. You can generate a token with `puppet access login`.
This command must be invoked on the primary master.

OPTIONS:
  --token-file <PATH>               Specifies path to an RBAC token to use for
                                    authentication. Defaults to ~/.puppetlabs/token.
  --force                           Skips all pre-provision validation. Useful
                                    if status checks time out. Skipping checks
                                    might cause provisioning steps to fail or
                                    require that you run them manually.
  --streaming                       Stream initial database replication. When
                                    provisioning a replica, use pg_basebackup to
                                    accelerate copying of the databases to the
                                    replica. Defaults to false.
  --render-as <FORMAT>              The rendering format to use.
  --verbose                         Whether to log verbosely.
  --debug                           Whether to log debug information.
  --trace                           Displays stack traces.
  --help, -h                        Displays man page.
```

## Examples
### Normal usage

```
A primary master replica is provisioning.
```
(Will this take a while? If so, show progress: says “Running Puppet on X machine”)

```
A primary master replica has been provisioned. Services are syncing. If you have a large PuppetDB, see <link> to learn how to speed up the replication process.

To track sync progress, enter `puppet infrastructure status -—host REPLICA NAME`

When the sync is complete, enter `puppet infrastructure enable replica HOSTNAME` on the primary master replica to enable failover from the primary master. If you enable the primary master replica before it is fully synchronized, it won’t have all the info required to replace the primary master during a failover.
```

### Errors
Error1 - Code Manager, file sync, orchestrator not enabled:

```
Puppet can’t provision a primary master replica until <Code Manager, file sync, orchestrator> is/are enabled.

Enable <Code Manager, file sync, orchestrator>, then enter `puppet infrastructure provision replica HOSTNAME` to provision a replica.
```

Error 2a - Node is not an agent connected via PCP. Orchestrator disabled.

```
The primary master replica uses the Puppet orchestrator for Puppet runs, but the orchestrator has been disabled. See <doc link> for information on re-enabling the orchestrator.
```

Error 2b - Node is not an agent connected via PCP. Node can’t be reached.
Current error:

```
Error: The node <HOSTNAME> is not connected to the master via PCP. Check that you are using the certname of the replica node, which may be different from the hostname.
Also verify that orchestration services are enabled on the master and that the PXP agent is running on <HOSTNAME>.
```

As spec'd:

```
The primary master replica node cannot be reached. Check the network connection.
```

Error3a - trying to provision a replica that’s already been provisioned, but hasn’t been enabled:

```
HOSTNAME is already provisioned as a primary master replica.

To see if the replica is ready to be enabled, enter `puppet infrastructure status —host REPLICA NAME`.

To enable the replica, enter `puppet infrastructure enable replica HOSTNAME`.
```

Error3b - trying to provision a replica that’s already been provisioned and enabled:

```
HOSTNAME is already enabled as a primary master replica.

To see the status of this primary master replica, enter `puppet infrastructure status —host REPLICA NAME`
```

Error4 - error while changing classification:

```
An error occurred while changing classification. Contact Puppet Customer Support <not sure if we typically give contact info here>.
```

Error5 - while running puppet

```
An error occurred while running Puppet. See the report at <link> for details.
```

Error6 - trying to provision a machine that is either the primary master or part of PE infrastructure
Current primary master error:

```
Error: <HOSTNAME> is already provisioned as the primary master.
```

As spec'd:
```
HOSTNAME is already being used as <specify>, so it can’t be used as a primary master replica.
```
