# Wrapper class to determine if pe_databases has been installed,
#   and whether it came from user code or PE profile code
class puppet_enterprise::pe_metrics() {
  if $settings::storeconfigs {
    # User version
    $has_metrics_collector = puppet_enterprise::class_previously_included('Puppet_metrics_collector')
    # PE version
    $has_pe_metrics_collector = puppet_enterprise::class_previously_included('Puppet_metrics_collector', 'pe_metrics_vendor_version')

    # There are two situations where we include the class here:
      # If it has not been applied previously by us or the user
      # If we have previously applied it and the class is not already part of this catalog compilation
    if (!$has_pe_metrics_collector and !$has_metrics_collector) or ($has_pe_metrics_collector and !defined(Class['puppet_metrics_collector'])) {
      class {'puppet_metrics_collector':
        tag => ['pe_metrics_vendor_version'],
      }
    }
  }
}
