#!/opt/puppetlabs/installer/bin/ruby
require 'hocon'
require 'hocon/config_syntax'

conf_file_path = ARGV[0]
conf = Hocon.load(conf_file_path,{:syntax => Hocon::ConfigSyntax::HOCON})
master = conf['puppet_enterprise::puppet_master_host']
console = conf['puppet_enterprise::console_host']
puppetdb = conf['puppet_enterprise::puppetdb_host']
if puppetdb && !puppetdb.kind_of?(Array)
  puppetdb = [puppetdb]
end

split = (master && console && puppetdb) && (master != console) && (!puppetdb.include?(master))

exit 1 if split
