plan enterprise_tasks::get_service_status(
  Variant[TargetSpec,String] $target,
  String $service,
) {
  # Ensuring that the service task executes it's puppet-agent impl so
  # that we're parsing consistent output.
  $_target = get_targets($target)
  $_target.each |TargetSpec $feature_target| {
    enterprise_tasks::set_feature($feature_target, 'puppet-agent', true)
  }

  $results = run_task(service, $_target,
    action  => 'status',
    name    => $service,
  )
  $status_hash = Hash($results.first().value())
  out::message("${service} resource service found in state: ${status_hash}")

  return $status_hash
}
