#!/opt/puppetlabs/puppet/bin/ruby

require_relative '../files/enterprise_task_helper.rb'
require 'json'
require 'open3'
require 'etc'

class EnableReplica < EnterpriseTaskHelper
  def task(host:, topology:, skip_agent_config: nil, agent_server_urls: nil, pcp_brokers: nil, token_file: nil, **_kwargs)
    cmd = ['/opt/puppetlabs/bin/puppet-infra', 'enable', 'replica', host, '--topology', topology, '-y']
    cmd += ['--token-file', token_file] if !token_file.nil?

    if topology == 'mono'
      # none of the agent configuration parameters are required
    elsif skip_agent_config
      cmd << '--skip-agent-config' # this is the only parameter required
    else
      if agent_server_urls
        cmd << '--agent-server-urls' << agent_server_urls
      end
      if pcp_brokers
        cmd << '--pcp-brokers' << pcp_brokers
      end
    end

    output, status = Open3.capture2e(*cmd)
    if !status.exitstatus.zero?
      raise EnterpriseTaskHelper::Error.new("Failed to enable replica with certname #{host}",
                                            'puppetlabs.enable-replica/enable-failed',
                                            'output' => output)
    end

    result = { _output: output }
    result.to_json
  end
end

# The HOME variable is required to run the provision command but may not exist
# when this task is executed using the orchestrator
ENV['HOME'] ||= Etc.getpwuid.dir # rubocop:disable Style/EnvHome (rule does not take into account assignment)

EnableReplica.run if __FILE__ == $PROGRAM_NAME
