# frozen_string_literal: true

# THIS IS A PE SPECIFIC IMPLEMENTATION OF write_file: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/boltlib/lib/puppet/functions/write_file.rb
#
# write_file for plans-in-PE will return an error since it is not needed in the current iteration
# of plans in PE.
Puppet::Functions.create_function(:run_task_with) do
  # Run a task with target-specific parameters.
  # @param task_name The task to run.
  # @param targets A pattern identifying zero or more targets. See {get_targets} for accepted patterns.
  # @param options A hash of additional options.
  # @option options [Boolean] _catch_errors Whether to catch raised errors.
  # @option options [Boolean] _noop Run the task in noop mode if available.
  # @option options [String] _run_as User to run as using privilege escalation.
  # @param block A block that returns a `Hash` of target-specific parameters for the task.
  # @return A list of results, one entry per target.
  # @example Run a task with target-specific parameters as root
  #   run_task_with('my_task', $targets, '_run_as' => 'root') |$t| {
  #     { 'param1' => $t.vars['var1'],
  #       'param2' => $t.vars['var2'] }
  #   }
  dispatch :run_task_with do
    param 'String[1]', :task_name
    param 'Boltlib::TargetSpec', :targets
    optional_param 'Hash[String[1], Any]', :options
    required_block_param 'Callable[Target]', :block
    return_type 'ResultSet'
  end

  # Run a task with target-specific parameters, logging the provided description.
  # @param task_name The task to run.
  # @param targets A pattern identifying zero or more targets. See {get_targets} for accepted patterns.
  # @param description A description to be output when calling this function.
  # @param options A hash of additional options.
  # @option options [Boolean] _catch_errors Whether to catch raised errors.
  # @option options [Boolean] _noop Run the task in noop mode if available.
  # @option options [String] _run_as User to run as using privilege escalation.
  # @param block A block that returns a `Hash` of target-specific parameters for the task.
  # @return A list of results, one entry per target.
  # @example Run a task with target-specific parameters and a description
  #   run_task_with('my_task', $targets, 'Update system packages') |$t| {
  #     { 'param1' => $t.vars['var1'],
  #       'param2' => $t.vars['var2'] }
  #   }
  dispatch :run_task_with_with_description do
    param 'String[1]', :task_name
    param 'Boltlib::TargetSpec', :targets
    param 'Optional[String]', :description
    optional_param 'Hash[String[1], Any]', :options
    required_block_param 'Callable[Target]', :block
    return_type 'ResultSet'
  end

  def run_task_with(task_name, targets, options = {}, &block)
    run_task_with_with_description(task_name, targets, nil, options, &block)
  end

  def run_task_with_with_description(task_name, targets, description, options = {})
    unless Puppet[:tasks]
      raise Puppet::ParseErrorWithIssue
        .from_issue_and_stack(Bolt::PAL::Issues::PLAN_OPERATION_NOT_SUPPORTED_WHEN_COMPILING, action: 'run_task_with')
    end
    # TODO: https://tickets.puppetlabs.com/browse/PE-29106
    raise Puppet::Error, "run_task_with is currently not supported in PE plans"
  end
end
