Puppet::Functions.create_function(:constants) do
  def constants
    # Used for test instances
    default_control_repo_path = '/opt/puppetlabs/server/data/pe-control-repo'

    {
      'agent_services'        => ['puppet', 'pxp-agent'],
      'ca_pem'                => '/etc/puppetlabs/puppet/ssl/certs/ca.pem',
      'pe_bin'                => '/opt/puppetlabs/bin',
      'pe_conf'               => '/etc/puppetlabs/enterprise/conf.d/pe.conf',
      'pe_services'           => ['pe-ace-server', 'pe-bolt-server', 'pe-console-services', 'pe-nginx', 'pe-orchestration-services', 'pe-postgresql', 'pe-puppetdb', 'pe-puppetserver', 'pe-host-action-collector'],
      'db_services'           => ['pe_databases-catalogs.service', 'pe_databases-facts.service', 'pe_databases-other.service', 'pe_databases-reports.service', 'pe_databases-resource_events.service'],
      'db_timers'             => ['pe_databases-catalogs.timer', 'pe_databases-facts.timer', 'pe_databases-other.timer', 'pe_databases-reports.timer', 'pe_databases-resource_events.timer'],
      # The postgresql9(4|6)_packages arrays are in this order so that when `ensure => absent`
      #   is called on each of them, it doesn't cause dependency conflicts (also, pg94 packages are unversioned)
      'postgresql94_packages' => ['pe-postgresql-pglogical', 'pe-postgresql-contrib', 'pe-postgresql-server', 'pe-postgresql'],
      'postgresql96_packages' => ['pe-postgresql96-pglogical', 'pe-postgresql96-pgrepack', 'pe-postgresql96-contrib', 'pe-postgresql96-server', 'pe-postgresql96'],
      'puppet_bin'            => '/opt/puppetlabs/bin/puppet',
      'rbac_account'          => 'pe-enterprise-tasks-user',
      'temp_allowlist_key'    => 'puppet_enterprise::profile::database::private_temp_puppetdb_hosts',
      'token_file'            => '/opt/puppetlabs/installer/share/enterprise-tasks-token',
      'user_data_conf'        => '/etc/puppetlabs/enterprise/conf.d/user_data.conf',
      'default_control_repo_url'  => "file://#{default_control_repo_path}",
      'default_control_repo_path' => default_control_repo_path,
      'puppetserver_conf_dir' => '/etc/puppetlabs/puppetserver/conf.d',
      'facter_fqdn'           => '/opt/puppetlabs/bin/facter fqdn --no-custom-facts --no-external-facts',
    }
  end
end
