#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require_relative '../lib/enterprise_tasks/puppet_helper.rb'

class PuppetBin < EnterpriseTaskHelper
  include EnterpriseTasks::PuppetHelper

  def task(**_kwargs)
    # In order to use paths with spaces in it on Windows, we need to escape them with `
    path = Gem.win_platform? ? puppet_bin.gsub(' ', '` ') : puppet_bin
    { puppet_bin: path }.to_json
  end
end

PuppetBin.run if __FILE__ == $PROGRAM_NAME
