# Perform any PuppetDB upgrade steps before starting the service
#
# Because upgrading PuppetDB may include lengthy migrations, this
# allows us to perform those migrations before starting the service,
# rather than setting a very long timeout on the service start to allow
# for the migrations.
#
# This needs to happen after any new java args and changes to the
# initconf settings (e.g. settings in /etc/sysconfig/<service>) are 
# laid down, and before the service starts up again.
class pe_install::upgrade::puppetdb (
  Optional[Boolean] $is_upgrade = $::pe_install::is_upgrade,
) {
  if $is_upgrade {
    Class['puppet_enterprise::puppetdb'] -> Class['pe_install::upgrade::puppetdb'] -> Exec['pe-puppetdb service full restart']

    notify { 'puppetdb upgrade warning':
      message => "We are about to perform a PuppetDB upgrade. This can potentially include lengthy migrations. You can monitor the progress of these migrations with 'tail -f /var/log/puppetlabs/puppetdb/puppetdb.log' in a separate terminal.",
    } ->
    exec { 'Run puppetdb upgrade':
      command   => '/opt/puppetlabs/bin/puppetdb upgrade',
      timeout   => 0,
    }
  }
}
