function puppet_enterprise::calculate_puppetserver_heap_size (
  Optional[Integer] $jruby_max_active_instances,
  Integer $ram_per_jruby = puppet_enterprise::puppetserver_ram_per_jruby(),
) >> Integer {
  $memorysize_in_mb = Integer($facts['memory']['system']['total_bytes']) / 1048576

  if $trusted['extensions']['pp_auth_role'] == 'pe_compiler' {
    $ram_puppetserver = ($jruby_max_active_instances * $ram_per_jruby)
  } else {
    if $memorysize_in_mb <= 1024 {
      $ram_puppetserver        = 512
    } elsif $memorysize_in_mb <= 2048 {
      $ram_puppetserver        = 1024
    } else {
      $ram_puppetserver        = 2048
    }
  }
}
