require 'puppet/indirector/face'
require 'puppet_x/puppetlabs/meep/destinations.rb'
require 'puppet_x/util/infrastructure_help'

Puppet::Face.define(:infrastructure, '1.0.0') do
  copyright "Puppet", 2016
  license   "Puppet Enterprise Software License Agreement"

  summary _("Manage configuration of Puppet Enterprise.")
  description <<-EOT
    This subcommand interacts with Puppet Enterprise infrastructure nodes for
    configuring state on the system or for setting up High Availability.
  EOT

  action :help do
    default
    summary _("Display help about the infrastructure subcommand.")
    when_invoked do |*args|
      action = args[0]
      if action.respond_to?(:to_sym)
        PuppetX::Util::InfrastructureHelp.action_help(action.to_sym)
      else
        Puppet::Face[:help, :current].help('infrastructure')
      end
    end
  end
end
