#!/opt/puppetlabs/puppet/bin/ruby
# frozen_string_literal: true

require_relative '../files/enterprise_task_helper.rb'
require_relative '../lib/enterprise_tasks/puppet_helper.rb'
require 'open3'
require 'fileutils'

class RemoveCachedCatalog < EnterpriseTaskHelper
  include EnterpriseTasks::PuppetHelper

  def task(**_kwargs)
    cmd = [puppet_bin, 'config', 'print', 'certname']
    certname, status = Open3.capture2e(*cmd)
    raise EnterpriseTaskHelper::Error.new('Error fetching certname', 'puppetlabs.remove-cached-catalog/certname-error', 'output' => certname) if !status.exitstatus.zero?
    certname = certname.chomp

    catalog = "#{catalog_path}/#{certname}.json"
    FileUtils.rm_f(catalog)
    if File.exist?(catalog)
      raise EnterpriseTaskHelper::Error.new("Unable to remove cached catalog on host with certname #{certname}", 'puppetlabs.remove-cached-catalog/remove-cached-catalog-failed', 'output' => output) if !status.exitstatus.zero?
    end
  end
end

RemoveCachedCatalog.run if __FILE__ == $PROGRAM_NAME
