define puppet_enterprise::pg::cert_whitelist_entry(
  String $user,
  String $database,
  String $allowed_client_certname,
  String $pg_ident_conf_path,
  String $ip_mask_allow_all_users_ssl,
  String $ipv6_mask_allow_all_users_ssl,
) {
  notify { "${title} using deprecated define":
    message  => "The puppet_enterprise::pg::cert_whitelist_entry define is deprecated and will be removed in a future release. Please use puppet_enterprise::pg::cert_allowlist_entry instead.",
    loglevel => 'warning',
  }
  puppet_enterprise::pg::cert_allowlist_entry { $title:
    user                          => $user,
    database                      => $database,
    allowed_client_certname       => $allowed_client_certname,
    pg_ident_conf_path            => $pg_ident_conf_path,
    ip_mask_allow_all_users_ssl   => $ip_mask_allow_all_users_ssl,
    ipv6_mask_allow_all_users_ssl => $ipv6_mask_allow_all_users_ssl,
  }
}
