#!/usr/bin/env ruby
# frozen_string_literal: true

# Edgeops Task Helper
#
# This helper enables custom tasks to use the puppetlabs-edgeops library
# by automatically setting up the Ruby load path.
#
# Usage in a task:
#   require_relative '../../edgeops/files/task_helper.rb'
#
# Task metadata.json:
#   "files": ["edgeops/files/task_helper.rb"]
#
# After including this helper, you can use:
#   require 'puppet_x/puppetlabs/netconf/session'
#
# The helper will automatically find the edgeops library whether:
# - Files are bundled by Bolt (production use)
# - Running locally for development
# - Using the module from various installation paths

# Tasks include this helper via: require_relative '../../edgeops/files/task_helper.rb'
# So we know the structure: we're at edgeops/files/task_helper.rb
# and the lib directory is at edgeops/lib (sibling to files)

# Add the edgeops lib directory to the load path
edgeops_lib_path = File.expand_path('../lib', __dir__)

if File.directory?(edgeops_lib_path)
  $LOAD_PATH.unshift(edgeops_lib_path) unless $LOAD_PATH.include?(edgeops_lib_path)
else
  warn "Warning: Could not find edgeops lib directory at #{edgeops_lib_path}"
end
