function puppet_enterprise::calculate_puppetdb_heap_size (
) >> Integer {
  $ram_in_mb = Integer($facts['memory']['system']['total_bytes']) / 1048576
  $percent_ram_puppetdb              = 0.10
  $minimum_ram_puppetdb              = 256
  $maximum_ram_puppetdb              = 8192

  if $trusted['extensions']['pp_auth_role'] == 'pe_compiler' {
    $puppetdb_heap_size = pe_clamp($minimum_ram_puppetdb, Integer($ram_in_mb * $percent_ram_puppetdb), $maximum_ram_puppetdb)
  } else {
    $puppetdb_heap_size = 256
  }
}
