# Grant read-only permissions to $table_reader for all objects in $schema of
# $database

define puppet_enterprise::pg::read_grant(
  String $database,
  String $schema,
  String $table_reader,
) {
  puppet_enterprise::psql {"${title}/tables":
    db      => $database,
    command => "GRANT SELECT
                ON ALL TABLES IN SCHEMA \"${schema}\"
                TO \"${table_reader}\"",
    # query that returns rows if all tables are readable.
    unless  => "SELECT * FROM (
                  SELECT COUNT(*)
                  FROM pg_tables
                  WHERE schemaname='public'
                    AND has_table_privilege('${table_reader}', schemaname || '.' || tablename, 'SELECT')=false
                ) x
                WHERE x.count=0",
  }

  puppet_enterprise::psql {"${title}/sequences":
    db      => $database,
    command => "GRANT USAGE
                ON ALL SEQUENCES IN SCHEMA \"${schema}\"
                TO \"${table_reader}\"",
    unless  => "SELECT * FROM (
                  SELECT COUNT(*)
                  FROM information_schema.sequences
                  WHERE sequence_schema='public'
                    AND has_sequence_privilege('${table_reader}', sequence_schema || '.' || sequence_name, 'USAGE')=false
                ) x
                WHERE x.count=0",
  }

  puppet_enterprise::psql {"${title}/functions":
    db      => $database,
    command => "GRANT EXECUTE
                ON ALL FUNCTIONS IN SCHEMA \"${schema}\"
                TO \"${table_reader}\"",
    unless  => "SELECT * FROM (
                  SELECT COUNT(*)
                  FROM pg_catalog.pg_proc p
                  LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace
                  WHERE n.nspname='public'
                    AND has_function_privilege('${table_reader}', p.oid, 'EXECUTE')=false
                ) x
                WHERE x.count=0",
  }
}
