# Class for configuring the value-report.conf file
#
#
# @param value_report_corrective_change_low [Integer] Sets the value report corrective change low value.
# @param value_report_corrective_change_med [Integer] Sets the value report corrective change med value.
# @param value_report_corrective_change_high [Integer] Sets the value report corrective change high value.
# @param value_report_intentional_change_low [Integer] Sets the value report intentional change low value.
# @param value_report_intentional_change_med [Integer] Sets the value report intentional change med value.
# @param value_report_intentional_change_high [Integer] Sets the value report intentional change high value.
# @param value_report_task_run_low [Integer] Sets the value report task run low value.
# @param value_report_task_run_med [Integer] Sets the value report task run med value.
# @param value_report_task_run_high [Integer] Sets the value report task run high value.
# @param value_report_plan_run_low [Integer] Sets the value report plan run low value.
# @param value_report_plan_run_med [Integer] Sets the value report plan run med value.
# @param value_report_plan_run_high [Integer] Sets the value report plan run high value.
class puppet_enterprise::profile::console::value_report_config (
  Optional[Integer] $value_report_corrective_change_low,
  Optional[Integer] $value_report_corrective_change_med,
  Optional[Integer] $value_report_corrective_change_high,

  Optional[Integer] $value_report_intentional_change_low,
  Optional[Integer] $value_report_intentional_change_med,
  Optional[Integer] $value_report_intentional_change_high,

  Optional[Integer] $value_report_task_run_low,
  Optional[Integer] $value_report_task_run_med,
  Optional[Integer] $value_report_task_run_high,

  Optional[Integer] $value_report_plan_run_low,
  Optional[Integer] $value_report_plan_run_med,
  Optional[Integer] $value_report_plan_run_high,
) {
  $container = 'console-services'
  $console_services_user  = "pe-${container}"
  $console_services_group = $console_services_user
  $value_report_conf_path = "/etc/puppetlabs/${container}/conf.d/value-report.conf"

  file { $value_report_conf_path :
    ensure  => file,
    owner   => $console_services_user,
    group   => $console_services_group,
    mode    => '0640',
    require => Package["pe-${container}"],
    notify  => Service["pe-${container}"],
  }

  $value_report_config_defaults = {
    'minutes-freed-per-corrective-change' => pe_delete_undef_values({
      'low'  => $value_report_corrective_change_low,
      'med'  => $value_report_corrective_change_med,
      'high' => $value_report_corrective_change_high}),
    'minutes-freed-per-intentional-change' => pe_delete_undef_values({
      'low'  => $value_report_intentional_change_low,
      'med'  => $value_report_intentional_change_med,
      'high' => $value_report_intentional_change_high}),
    'minutes-freed-per-task-run' => pe_delete_undef_values({
      'low'  => $value_report_task_run_low,
      'med'  => $value_report_task_run_med,
      'high' => $value_report_task_run_high}),
    'minutes-freed-per-plan-run' => pe_delete_undef_values({
      'low'  => $value_report_plan_run_low,
      'med'  => $value_report_plan_run_med,
      'high' => $value_report_plan_run_high})
  }

  pe_hocon_setting { "${container}.console.value-report.defaults" :
    path    => $value_report_conf_path,
    setting => 'value-report.defaults',
    value   => $value_report_config_defaults,
    type    => 'hash',
    notify  => Service["pe-${container}"],
  }
}
