# Enable or disable the pe-workflow-service.
#
# On failure, should return a standard error hash with msg, kind, and details.
#
# @param primary The certname of the primary.
# @param enable True to enable the pe-workflow-service.
# @param force Can be set true to skip verifying that the given primary certificate name
# has the Primary role. There shouldn't be a good reason to use this, since inability
# to verify would be indicative of a failure on puppetdb, which should probably
# be addressed before attempting to modify workflow service status. But verify_node
# expects a force value.
# @param timeout Number of seconds to wait for workflow service status before failing.
plan enterprise_tasks::toggle_workflow_service (
  TargetSpec $primary,
  Boolean $enable  = true,
  Boolean $force   = false,
  Integer $timeout = 300,
) {
  $plan = 'enterprise_tasks::toggle_workflow_service'
  $service_name = 'pe-workflow-service'

  $primary_target = get_targets($primary)[0]

  enterprise_tasks::test_connection($primary_target)
  enterprise_tasks::verify_node($primary_target, 'primary', $force)

  run_task(service, $primary_target,
    action => 'stop',
    name   => $service_name,
  )

  run_task('enterprise_tasks::update_node_group', $primary_target,
    'group_name'       => 'PE Master',
    'class_parameters' => {
      'puppet_enterprise::profile::master' => {
        'enable_workflow_service' => $enable,
      },
    },
  )

  enterprise_tasks::with_agent_disabled($primary_target) |$agent| {
    enterprise_tasks::message($plan, 'Run Puppet to update service status.')
    run_task('enterprise_tasks::run_puppet', $primary_target)
    enterprise_tasks::message($plan, 'Run Puppet again to update services.conf.')
    run_task('enterprise_tasks::run_puppet', $primary_target)
  }

  if $enable {
    run_plan('facts', 'targets' => $primary_target)
    run_task('enterprise_tasks::wait_for_service', $primary_target,
      'host'    => $primary_target.facts()['fqdn'],
      'service' => $service_name,
      'timeout' => $timeout,
    )
  }

  $plan_result = { 'success' => true }
  return($plan_result)
}
