#!/opt/puppetlabs/puppet/bin/ruby

require_relative '../files/enterprise_task_helper.rb'
require 'json'
require 'open3'
require 'erb'

def get_databases
  ['pe-activity', 'pe-classifier', 'pe-orchestrator', 'pe-rbac', 'pe-inventory', 'pe-hac', 'pe-patching', 'pe-infra-assistant', 'pe-workflow']
end

def get_template
  %{
su -s /bin/bash - pe-postgres -c "/opt/puppetlabs/server/bin/psql -v ON_ERROR_STOP=1" <<EOF
SELECT pg_drop_replication_slot(slot_name) FROM pg_replication_slots;
UPDATE pg_database SET datallowconn = 'false'
  WHERE datname IN <%= '(' + @databases.map{ |database| "'" + database + "'" }.join(', ') + ');' %>
SELECT pg_terminate_backend(pid) FROM pg_stat_activity
  WHERE datname IN <%= '(' + @databases.map{ |database| "'" + database + "'" }.join(', ') + ');' %>
<% for @database in @databases %><%='DROP DATABASE IF EXISTS ' + '"' + @database + '";' %>
<% end %>EOF
  }
end

class PostgresDropDatabaseCommand
  include ERB::Util
  attr_accessor :databases, :template

  def initialize(databases, template)
    @databases = databases
    @template = template
  end

  def render
    ERB.new(@template).result(binding)
  end
end

class DropPGLogicalDatabases < EnterpriseTaskHelper
  def task(host: nil, **_kwargs)
    host, = Open3.capture2e('hostname -f') if !host

    output, status = Open3.capture2e('/opt/puppetlabs/bin/puppet resource service pe-postgresql ensure=running')
    raise EnterpriseTaskHelper::Error.new("Failed to start pe-postgresql service on host #{host}", 'puppetlabs.drop-pglogical-databases/restart-postgres-failed', 'output' => output) if !status.exitstatus.zero?

    postgres_command = PostgresDropDatabaseCommand.new(get_databases, get_template).render
    output, status = Open3.capture2e(postgres_command)
    raise EnterpriseTaskHelper::Error.new("Failed to drop pglogical databases on host #{host}. Output: #{output}", 'puppetlabs.drop-pglogical-databases/drop-databases-failed', 'output' => output) if !status.exitstatus.zero?

    output, status = Open3.capture2e('/opt/puppetlabs/bin/puppet resource service pe-postgresql ensure=stopped')
    raise EnterpriseTaskHelper::Error.new("Failed to stop pe-postgresql service on host #{host}", 'puppetlabs.drop-pglogical-databases/restart-postgres-failed', 'output' => output) if !status.exitstatus.zero?

    result = { _output: output }
    result.to_json
  end
end

DropPGLogicalDatabases.run if __FILE__ == $PROGRAM_NAME
