# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`puppet_agent`](#puppet_agent): Upgrades Puppet 4 and newer to the requested version.
* [`puppet_agent::configure`](#puppet_agent--configure): Uses $puppet_agent::config to manage settings in puppet.conf.
* [`puppet_agent::install`](#puppet_agent--install): This class is called from puppet_agent for install.
* [`puppet_agent::install::darwin`](#puppet_agent--install--darwin): Manage the install process for Darwin OSes specifically.
* [`puppet_agent::install::solaris`](#puppet_agent--install--solaris): Manage the install process for Solaris OSes specifically.
* [`puppet_agent::install::suse`](#puppet_agent--install--suse): Manage the install process for SUSE OSes specifically.
* [`puppet_agent::install::windows`](#puppet_agent--install--windows): Manage the install process for Windows OSes specifically.
* [`puppet_agent::osfamily::aix`](#puppet_agent--osfamily--aix): Used to determine the puppet-agent package location for AIX OSes.
* [`puppet_agent::osfamily::darwin`](#puppet_agent--osfamily--darwin): Used to determine the puppet-agent package location for Darwin OSes.
* [`puppet_agent::osfamily::debian`](#puppet_agent--osfamily--debian): Determines the puppet-agent package location for Debian OSes.
* [`puppet_agent::osfamily::redhat`](#puppet_agent--osfamily--redhat): Determines the puppet-agent package location for RedHat OSes.
* [`puppet_agent::osfamily::solaris`](#puppet_agent--osfamily--solaris): Determines the puppet-agent package location for Solaris OSes.
* [`puppet_agent::osfamily::suse`](#puppet_agent--osfamily--suse): Determines the puppet-agent package location for SUSE OSes.
* [`puppet_agent::osfamily::windows`](#puppet_agent--osfamily--windows): Determines the puppet-agent package location for Windows OSes.
* [`puppet_agent::params`](#puppet_agent--params): Sets variables according to platform.
* [`puppet_agent::prepare`](#puppet_agent--prepare): This class is called from puppet_agent to prepare for the upgrade.
* [`puppet_agent::prepare::puppet_config`](#puppet_agent--prepare--puppet_config): Private class called from puppet_agent::prepare class.
* [`puppet_agent::service`](#puppet_agent--service): Ensures that managed services are running.

#### Private Classes

* `puppet_agent::prepare::package`: Ensures correct puppet-agent package is downloaded locally.

### Resource types

* [`puppet_agent_end_run`](#puppet_agent_end_run): Stops the current Puppet run if a puppet-agent upgrade was performed. Used on platforms that manage the Puppet Agent upgrade with a package r
* [`puppet_agent_upgrade_error`](#puppet_agent_upgrade_error): Fails when a previous background installation failed. The type will check for the existance of an installation failure log and raise an error

### Functions

* [`any_resources_of_type`](#any_resources_of_type): A function used to determine if there are any
* [`uri_host_from_string`](#uri_host_from_string)
* [`windows_msi_installargs`](#windows_msi_installargs)
* [`windows_native_path`](#windows_native_path)

### Data types

* [`Puppet_agent::Arch`](#Puppet_agent--Arch): This type stores all possible architecture patterns
* [`Puppet_agent::Config`](#Puppet_agent--Config): This Puppet type alias
* [`Puppet_agent::Config_setting`](#Puppet_agent--Config_setting): An enumerated list of settings which are permitted to be managed by this module.

### Tasks

* [`delete_local_filebucket`](#delete_local_filebucket): Removes the local filebucket
* [`facts_diff`](#facts_diff): Run the Puppet agent facts diff action
* [`install`](#install): Install the Puppet agent package
* [`install_powershell`](#install_powershell): Install the Puppet agent package
* [`install_shell`](#install_shell): Install the Puppet agent package
* [`run`](#run): Run the Puppet agent. This task may cause problems if run in Puppet Enterprise.
* [`version`](#version): Get the version of the Puppet agent package installed. Returns nothing if none present.
* [`version_powershell`](#version_powershell): Get the version of the Puppet agent package installed. Returns nothing if none present.
* [`version_shell`](#version_shell): Get the version of the Puppet agent package installed. Returns nothing if none present.

### Plans

* [`puppet_agent::run`](#puppet_agent--run): Starts a Puppet agent run on the specified targets. Note: This plan may cause issues when run in Puppet Enterprise.

## Classes

### <a name="puppet_agent"></a>`puppet_agent`

Upgrades Puppet 4 and newer to the requested version.

#### Parameters

The following parameters are available in the `puppet_agent` class:

* [`arch`](#-puppet_agent--arch)
* [`collection`](#-puppet_agent--collection)
* [`is_pe`](#-puppet_agent--is_pe)
* [`manage_pki_dir`](#-puppet_agent--manage_pki_dir)
* [`manage_repo`](#-puppet_agent--manage_repo)
* [`package_name`](#-puppet_agent--package_name)
* [`package_version`](#-puppet_agent--package_version)
* [`service_names`](#-puppet_agent--service_names)
* [`source`](#-puppet_agent--source)
* [`absolute_source`](#-puppet_agent--absolute_source)
* [`yum_source`](#-puppet_agent--yum_source)
* [`apt_source`](#-puppet_agent--apt_source)
* [`mac_source`](#-puppet_agent--mac_source)
* [`windows_source`](#-puppet_agent--windows_source)
* [`solaris_source`](#-puppet_agent--solaris_source)
* [`aix_source`](#-puppet_agent--aix_source)
* [`use_alternate_sources`](#-puppet_agent--use_alternate_sources)
* [`alternate_pe_source`](#-puppet_agent--alternate_pe_source)
* [`install_dir`](#-puppet_agent--install_dir)
* [`install_options`](#-puppet_agent--install_options)
* [`msi_move_locked_files`](#-puppet_agent--msi_move_locked_files)
* [`wait_for_pxp_agent_exit`](#-puppet_agent--wait_for_pxp_agent_exit)
* [`wait_for_puppet_run`](#-puppet_agent--wait_for_puppet_run)
* [`config`](#-puppet_agent--config)
* [`proxy`](#-puppet_agent--proxy)
* [`version_file_path`](#-puppet_agent--version_file_path)
* [`skip_if_unavailable`](#-puppet_agent--skip_if_unavailable)
* [`disable_proxy`](#-puppet_agent--disable_proxy)
* [`username`](#-puppet_agent--username)
* [`password`](#-puppet_agent--password)

##### <a name="-puppet_agent--arch"></a>`arch`

Data type: `String`

The package architecture. Defaults to the architecture fact.

Default value: `$facts['os']['architecture']`

##### <a name="-puppet_agent--collection"></a>`collection`

Data type: `String`

The Puppet Collection to track. Defaults to 'PC1'. Valid values are puppet7,
puppet8, puppet, puppet7-nightly, puppet8-nightly, puppet-nightly,
puppetcore7, puppetcore8.

Default value: `$puppet_agent::params::collection`

##### <a name="-puppet_agent--is_pe"></a>`is_pe`

Data type: `Boolean`

Install from Puppet Enterprise repos. Enabled if communicating with a PE master.

Default value: `$puppet_agent::params::_is_pe`

##### <a name="-puppet_agent--manage_pki_dir"></a>`manage_pki_dir`

Data type: `Boolean`

Whether or not to manage the /etc/pki directory.  Defaults to true.
Managing the /etc/pki directory inside the puppet_agent module can be problematic for
organizations that manage gpg keys and settings in other modules.

Default value: `true`

##### <a name="-puppet_agent--manage_repo"></a>`manage_repo`

Data type: `Boolean`

Boolean to determine whether to configure repositories
This is intended to provide the ability to disable configuring a local repo
in support of systems that manage external repositories (i.e. spacewalk/satellite)
to enable users to add the proper packages to their internal repos
and to utilize default package providers for the install

Default value: `true`

##### <a name="-puppet_agent--package_name"></a>`package_name`

Data type: `String`

The package to upgrade to, i.e. `puppet-agent`.

Default value: `'puppet-agent'`

##### <a name="-puppet_agent--package_version"></a>`package_version`

Data type: `Optional`

The package version to upgrade to. Explicitly specify the version to upgrade to,
or set to 'auto' to specify the version of the compiling master.

Default value: `undef`

##### <a name="-puppet_agent--service_names"></a>`service_names`

Data type: `Array`

An array of services to start, normally `puppet`.
None will be started if the array is empty.

Default value: `$puppet_agent::params::service_names`

##### <a name="-puppet_agent--source"></a>`source`

Data type: `Optional`

**INCLUDED FOR COMPATIBILITY WITH MODULE VERSIONS 1.0/2.0. PREFER USE OF "absolute_source",
"apt_source", "deb_source" etc. OVER USE OF "source".**

The location to find packages. Replaces base URL for unix/MacOS agents, used as fully
qualified path in windows

Default value: `undef`

##### <a name="-puppet_agent--absolute_source"></a>`absolute_source`

Data type: `Optional`

The exact location of the package to install. The entire path to the package must be
provided with this parameter.

Default value: `undef`

##### <a name="-puppet_agent--yum_source"></a>`yum_source`

Data type: `String`

Base URL of the location of mirrors of yum.puppet.com downloads sites. Directories under
the URL "yum_source" should match the structure of the yum.puppet.com

Default value: `'http://yum.puppet.com'`

##### <a name="-puppet_agent--apt_source"></a>`apt_source`

Data type: `String`

Base URL of the location of mirrors of apt.puppet.com downloads sites. Directories under
the URL "apt_source" should match the structure of the apt.puppet.com

Default value: `'https://apt.puppet.com'`

##### <a name="-puppet_agent--mac_source"></a>`mac_source`

Data type: `String`

Base URL of the location of mirrors of downloads.puppet.com downloads site that serves
MacOS packages. Directories under the URL "mac_source" should match the structure of the
downloads.puppet.com site

Default value: `'https://downloads.puppet.com'`

##### <a name="-puppet_agent--windows_source"></a>`windows_source`

Data type: `String`

Base URL of the location of mirrors of downloads.puppet.com downloads site that serves
Windows packages. Directories under the URL "windows_source" should match the structure of
the downloads.puppet.com site

Default value: `'https://downloads.puppet.com'`

##### <a name="-puppet_agent--solaris_source"></a>`solaris_source`

Data type: `String`

Base URL of the location of a mirror for Solaris packages. Currently, solaris packages can
only be made available by using puppetlabs-pe_repo. This means the mirror must be of a
PE master package serve.

Default value: `'puppet:///pe_packages'`

##### <a name="-puppet_agent--aix_source"></a>`aix_source`

Data type: `String`

Base URL of the location of a mirror for AIX packages. Currently, AIX packages can
only be made available by using puppetlabs-pe_repo. This means the mirror must be of a
PE master package serve.

Default value: `'puppet:///pe_packages'`

##### <a name="-puppet_agent--use_alternate_sources"></a>`use_alternate_sources`

Data type: `Boolean`

**ONLY APPLICABLE WHEN WORKING WITH PE INSTALLTIONS**
When set to true will force downloads to come from the values of $apt_source, $deb_source
$mac_source etc. rather than from the default PE master package serve. Note that this will
also force downloads to ignore alternate_pe_source

Default value: `false`

##### <a name="-puppet_agent--alternate_pe_source"></a>`alternate_pe_source`

Data type: `Optional`

Base URL of the location where packages are located in the same structure that's served
by a PE master (the directory structure in PE for serving packages is created by the
puppetlabs-pe_repo module). The general structure served by PE is:
/packages/${pe_server_version}/${platform_tag}/${package_name}

Default value: `undef`

##### <a name="-puppet_agent--install_dir"></a>`install_dir`

Data type: `Optional[Stdlib::Absolutepath]`

The directory the puppet agent should be installed to. This is only applicable for
windows operating systems. This only applies when upgrading the agent to a new
version; it will not cause re-installation of the same version to a new location.

Default value: `undef`

##### <a name="-puppet_agent--install_options"></a>`install_options`

Data type: `Array`

An array of additional options to pass when installing puppet-agent. Each option in
the array can either be a string or a hash. Each option will automatically be quoted
when passed to the install command. With Windows packages, note that file paths in an
install option must use backslashes. (Since install options are passed directly to
the installation command, forward slashes won't be automatically converted like they
are in `file` resources.) Note also that backslashes in double-quoted strings _must_
be escaped and backslashes in single-quoted strings _can_ be escaped.

Default value: `[]`

##### <a name="-puppet_agent--msi_move_locked_files"></a>`msi_move_locked_files`

Data type: `Boolean`

This is only applicable for Windows operating systems. There may be instances where
file locks cause unncessary service restarts.  By setting to true, the module
will move files prior to installation that are known to cause file locks.

Default value: `false`

##### <a name="-puppet_agent--wait_for_pxp_agent_exit"></a>`wait_for_pxp_agent_exit`

Data type: `Optional`

This parameter is only applicable for Windows operating systems and pertains to the
/files/install_agent.ps1 script. This parameterizes the module to define the wait time
for the PXP agent to end successfully. The default value is set 2 minutes.

Default value: `undef`

##### <a name="-puppet_agent--wait_for_puppet_run"></a>`wait_for_puppet_run`

Data type: `Optional`

This parameter is only applicable for Windows operating systems and pertains to the
/files/install_agent.ps1 script. This parameterizes the module to define the wait time
for the current puppet agent run to end successfully. The default value is set 2 minutes.

Default value: `undef`

##### <a name="-puppet_agent--config"></a>`config`

Data type: `Array[Puppet_agent::Config]`

An array of configuration data to enforce. Each configuration data item must be a
Puppet_agent::Config hash, which has keys for puppet.conf section, setting, and value.
This parameter is constrained to managing only a predetermined set of configuration
settings, e.g. runinterval.

Default value: `[]`

##### <a name="-puppet_agent--proxy"></a>`proxy`

Data type: `Optional`

This is to be able to configure yum-repo with proxy, needed for
example for clients in DMZs that need to use proxy to reach the repo
provided by puppetserver.

Default value: `undef`

##### <a name="-puppet_agent--version_file_path"></a>`version_file_path`

Data type: `Stdlib::Absolutepath`

The default install path for the VERSION file

Default value: `'/opt/puppetlabs/puppet/VERSION'`

##### <a name="-puppet_agent--skip_if_unavailable"></a>`skip_if_unavailable`

Data type: `Variant[Boolean, String]`

For yum-based repositories, set the skip_if_unavailable option of the `yumrepo` type.

Default value: `'absent'`

##### <a name="-puppet_agent--disable_proxy"></a>`disable_proxy`

Data type: `Boolean`



Default value: `false`

##### <a name="-puppet_agent--username"></a>`username`

Data type: `Optional`

The username to use when downloading from a source location requiring authentication.

Default value: `undef`

##### <a name="-puppet_agent--password"></a>`password`

Data type: `Optional[Sensitive]`

The password to use when downloading from a source location requiring authentication.

Default value: `undef`

### <a name="puppet_agent--configure"></a>`puppet_agent::configure`

It does not require management of the agent package.

### <a name="puppet_agent--install"></a>`puppet_agent::install`

This class is called from puppet_agent for install.

#### Parameters

The following parameters are available in the `puppet_agent::install` class:

* [`package_version`](#-puppet_agent--install--package_version)
* [`install_dir`](#-puppet_agent--install--install_dir)
* [`install_options`](#-puppet_agent--install--install_options)

##### <a name="-puppet_agent--install--package_version"></a>`package_version`

Data type: `String`

The puppet-agent version to install.

Default value: `'present'`

##### <a name="-puppet_agent--install--install_dir"></a>`install_dir`

Data type: `Optional[Stdlib::Absolutepath]`

The directory the puppet agent should be installed to. This is only applicable for
windows operating systems.

Default value: `undef`

##### <a name="-puppet_agent--install--install_options"></a>`install_options`

Data type: `Array[Variant[String, Hash]]`

An array of additional options to pass when installing puppet-agent. Each option in
the array can either be a string or a hash. Each option will automatically be quoted
when passed to the install command. With Windows packages, note that file paths in an
install option must use backslashes. (Since install options are passed directly to
the installation command, forward slashes won't be automatically converted like they
are in `file` resources.) Note also that backslashes in double-quoted strings _must_
be escaped and backslashes in single-quoted strings _can_ be escaped.

Default value: `[]`

### <a name="puppet_agent--install--darwin"></a>`puppet_agent::install::darwin`

Private class called from puppet_agent class.

#### Parameters

The following parameters are available in the `puppet_agent::install::darwin` class:

* [`package_version`](#-puppet_agent--install--darwin--package_version)
* [`install_options`](#-puppet_agent--install--darwin--install_options)

##### <a name="-puppet_agent--install--darwin--package_version"></a>`package_version`

Data type: `String`

The puppet-agent version to install.

##### <a name="-puppet_agent--install--darwin--install_options"></a>`install_options`

Data type: `Array[Variant[String, Hash]]`

An array of additional options to pass when installing puppet-agent. Each option in
the array can either be a string or a hash. Each option will automatically be quoted
when passed to the install command. With Windows packages, note that file paths in an
install option must use backslashes. (Since install options are passed directly to
the installation command, forward slashes won't be automatically converted like they
are in `file` resources.) Note also that backslashes in double-quoted strings _must_
be escaped and backslashes in single-quoted strings _can_ be escaped.

Default value: `[]`

### <a name="puppet_agent--install--solaris"></a>`puppet_agent::install::solaris`

Private class called from puppet_agent class.

#### Parameters

The following parameters are available in the `puppet_agent::install::solaris` class:

* [`package_version`](#-puppet_agent--install--solaris--package_version)
* [`install_options`](#-puppet_agent--install--solaris--install_options)

##### <a name="-puppet_agent--install--solaris--package_version"></a>`package_version`

Data type: `String`

The puppet-agent version to install.

##### <a name="-puppet_agent--install--solaris--install_options"></a>`install_options`

Data type: `Array[Variant[String, Hash]]`

An array of additional options to pass when installing puppet-agent. Each option in
the array can either be a string or a hash. Each option will automatically be quoted
when passed to the install command. With Windows packages, note that file paths in an
install option must use backslashes. (Since install options are passed directly to
the installation command, forward slashes won't be automatically converted like they
are in `file` resources.) Note also that backslashes in double-quoted strings _must_
be escaped and backslashes in single-quoted strings _can_ be escaped.

Default value: `[]`

### <a name="puppet_agent--install--suse"></a>`puppet_agent::install::suse`

Private class called from puppet_agent class.

#### Parameters

The following parameters are available in the `puppet_agent::install::suse` class:

* [`package_version`](#-puppet_agent--install--suse--package_version)
* [`install_options`](#-puppet_agent--install--suse--install_options)

##### <a name="-puppet_agent--install--suse--package_version"></a>`package_version`

Data type: `String`

The puppet-agent version to install.

##### <a name="-puppet_agent--install--suse--install_options"></a>`install_options`

Data type: `Array[Variant[String, Hash]]`

An array of additional options to pass when installing puppet-agent.
Each option in the array can either be a string or a hash.
Each option will automatically be quoted when passed to the install command.
With Windows packages, note that file paths in an install option must use
backslashes. (Since install options are passed directly to the installation
command, forward slashes won't be automatically converted like they are in
`file` resources.) Note also that backslashes in double-quoted strings
_must_ be escaped and backslashes in single-quoted strings _can_ be escaped.

Default value: `[]`

### <a name="puppet_agent--install--windows"></a>`puppet_agent::install::windows`

Private class called from puppet_agent class.

#### Parameters

The following parameters are available in the `puppet_agent::install::windows` class:

* [`install_options`](#-puppet_agent--install--windows--install_options)
* [`install_dir`](#-puppet_agent--install--windows--install_dir)

##### <a name="-puppet_agent--install--windows--install_options"></a>`install_options`

Data type: `Array[Variant[String, Hash]]`

An array of additional options to pass when installing puppet-agent. Each option in
the array can either be a string or a hash. Each option will automatically be quoted
when passed to the install command. With Windows packages, note that file paths in an
install option must use backslashes. (Since install options are passed directly to
the installation command, forward slashes won't be automatically converted like they
are in `file` resources.) Note also that backslashes in double-quoted strings _must_
be escaped and backslashes in single-quoted strings _can_ be escaped.

Default value: `[]`

##### <a name="-puppet_agent--install--windows--install_dir"></a>`install_dir`

Data type: `Optional`

The directory the puppet agent should be installed to. This is only applicable for
windows operating systems.

Default value: `undef`

### <a name="puppet_agent--osfamily--aix"></a>`puppet_agent::osfamily::aix`

Used to determine the puppet-agent package location for AIX OSes.

### <a name="puppet_agent--osfamily--darwin"></a>`puppet_agent::osfamily::darwin`

Used to determine the puppet-agent package location for Darwin OSes.

### <a name="puppet_agent--osfamily--debian"></a>`puppet_agent::osfamily::debian`

Determines the puppet-agent package location for Debian OSes.

### <a name="puppet_agent--osfamily--redhat"></a>`puppet_agent::osfamily::redhat`

Determines the puppet-agent package location for RedHat OSes.

### <a name="puppet_agent--osfamily--solaris"></a>`puppet_agent::osfamily::solaris`

Determines the puppet-agent package location for Solaris OSes.

### <a name="puppet_agent--osfamily--suse"></a>`puppet_agent::osfamily::suse`

Determines the puppet-agent package location for SUSE OSes.

### <a name="puppet_agent--osfamily--windows"></a>`puppet_agent::osfamily::windows`

Determines the puppet-agent package location for Windows OSes.

### <a name="puppet_agent--params"></a>`puppet_agent::params`

This class is meant to be called from puppet_agent.

### <a name="puppet_agent--prepare"></a>`puppet_agent::prepare`

This class is called from puppet_agent to prepare for the upgrade.

#### Parameters

The following parameters are available in the `puppet_agent::prepare` class:

* [`package_version`](#-puppet_agent--prepare--package_version)

##### <a name="-puppet_agent--prepare--package_version"></a>`package_version`

Data type: `Optional`

The puppet-agent version to install.

Default value: `undef`

### <a name="puppet_agent--prepare--puppet_config"></a>`puppet_agent::prepare::puppet_config`

Private class called from puppet_agent::prepare class.

#### Parameters

The following parameters are available in the `puppet_agent::prepare::puppet_config` class:

* [`package_version`](#-puppet_agent--prepare--puppet_config--package_version)

##### <a name="-puppet_agent--prepare--puppet_config--package_version"></a>`package_version`

Data type: `String`

The puppet-agent version to install.

### <a name="puppet_agent--service"></a>`puppet_agent::service`

This class is meant to be called from puppet_agent.

## Resource types

### <a name="puppet_agent_end_run"></a>`puppet_agent_end_run`

Stops the current Puppet run if a puppet-agent upgrade was
performed. Used on platforms that manage the Puppet Agent upgrade with
a package resource, as resources evaluated after an upgrade might
cause unexpected behavior due to a mix of old and new Ruby code being
loaded in memory.

Platforms that shell out to external scripts for upgrading (Windows,
macOS, and Solaris 10) do not need to use this type.

#### Properties

The following properties are available in the `puppet_agent_end_run` type.

##### `end_run`

Stops the current puppet run

#### Parameters

The following parameters are available in the `puppet_agent_end_run` type.

* [`name`](#-puppet_agent_end_run--name)
* [`provider`](#-puppet_agent_end_run--provider)

##### <a name="-puppet_agent_end_run--name"></a>`name`

namevar

The desired puppet-agent version

##### <a name="-puppet_agent_end_run--provider"></a>`provider`

The specific backend to use for this `puppet_agent_end_run` resource. You will seldom need to specify this --- Puppet
will usually discover the appropriate provider for your platform.

### <a name="puppet_agent_upgrade_error"></a>`puppet_agent_upgrade_error`

Fails when a previous background installation failed. The type
will check for the existance of an installation failure log
and raise an error with the contents of the log if it exists

#### Properties

The following properties are available in the `puppet_agent_upgrade_error` type.

##### `ensure_notexist`

whether or not the error log exists

#### Parameters

The following parameters are available in the `puppet_agent_upgrade_error` type.

* [`name`](#-puppet_agent_upgrade_error--name)
* [`provider`](#-puppet_agent_upgrade_error--provider)

##### <a name="-puppet_agent_upgrade_error--name"></a>`name`

namevar

The name of the failure log to check for in puppet's $statedir. If this log exists the resource will fail.

##### <a name="-puppet_agent_upgrade_error--provider"></a>`provider`

The specific backend to use for this `puppet_agent_upgrade_error` resource. You will seldom need to specify this ---
Puppet will usually discover the appropriate provider for your platform.

## Functions

### <a name="any_resources_of_type"></a>`any_resources_of_type`

Type: Ruby 4.x API

Puppet::Parser::Resource instances of the passed in resource type

#### `any_resources_of_type(String $resource_type, Optional[Hash[Any, Any]] $parameters)`

Puppet::Parser::Resource instances of the passed in resource type

Returns: `Boolean` Whether there are any instances of resource_type

##### `resource_type`

Data type: `String`

Resource type that is being looked for

##### `parameters`

Data type: `Optional[Hash[Any, Any]]`

Optional parameters

### <a name="uri_host_from_string"></a>`uri_host_from_string`

Type: Ruby 3.x API

The uri_host_from_string function.

#### `uri_host_from_string()`

The uri_host_from_string function.

Returns: `Any` Return a uri host from a string

### <a name="windows_msi_installargs"></a>`windows_msi_installargs`

Type: Ruby 3.x API

The windows_msi_installargs function.

#### `windows_msi_installargs()`

The windows_msi_installargs function.

Returns: `String` Return the $install_options parameter as a string usable in an msiexec command

### <a name="windows_native_path"></a>`windows_native_path`

Type: Ruby 3.x API

The windows_native_path function.

#### `windows_native_path()`

The windows_native_path function.

Returns: `Any` Return a windows native path

## Data types

### <a name="Puppet_agent--Arch"></a>`Puppet_agent::Arch`

This type stores all possible architecture patterns

Alias of `Pattern[/^x86$/, /^x64$/, /^i386$/, /^i86pc$/, /^amd64$/, /^x86_64$/, /^power$/, /^sun4[uv]$/, /^ppc64le$/, /^aarch64$/, /PowerPC_POWER/]`

### <a name="Puppet_agent--Config"></a>`Puppet_agent::Config`

This Puppet type alias

Alias of

```puppet
Variant[Struct[{ section          => Enum[main, server, agent, user, master],
                                            setting          => Puppet_agent::Config_setting,
                                            value            => String,
                                            Optional[ensure] => Enum[present, absent] }], Struct[{ section          => Enum[main, server, agent, user, master],
                                            setting          => Puppet_agent::Config_setting,
                                            Optional[ensure] => Enum[absent] }]]
```

### <a name="Puppet_agent--Config_setting"></a>`Puppet_agent::Config_setting`

An enumerated list of settings which are permitted to be managed by this
module.

Alias of `Enum[agent_catalog_run_lockfile, agent_disabled_lockfile, allow_duplicate_certs, allow_pson_serialization, always_retry_plugins, autoflush, autosign, basemodulepath, binder_config, bucketdir, ca_fingerprint, ca_name, ca_port, ca_refresh_interval, ca_server, ca_ttl, cacert, cacrl, cadir, cakey, capub, catalog_cache_terminus, catalog_terminus, cert_inventory, certdir, certificate_revocation, certname, ciphers, classfile, client_datadir, clientbucketdir, clientyamldir, code, codedir, color, confdir, config, config_file_name, config_version, configprint, crl_refresh_interval, csr_attributes, csrdir, daemonize, data_binding_terminus, default_file_terminus, default_manifest, default_schedules, deviceconfdir, deviceconfig, devicedir, diff, diff_args, digest_algorithm, disable_i18n, disable_per_environment_manifest, disable_warnings, dns_alt_names, document_all, environment, environment_data_provider, environment_timeout, environment_timeout_mode, environmentpath, evaltrace, exclude_unchanged_resources, external_nodes, fact_name_length_soft_limit, fact_value_length_soft_limit, facterng, factpath, facts_terminus, fileserverconfig, filetimeout, forge_authorization, freeze_main, func3x_check, future_features, genconfig, genmanifest, graph, graphdir, group, hiera_config, hostcert, hostcert_renewal_interval, hostcrl, hostcsr, hostprivkey, hostpubkey, http_connect_timeout, http_debug, http_extra_headers, http_keepalive_timeout, http_proxy_host, http_proxy_password, http_proxy_port, http_proxy_user, http_read_timeout, http_user_agent, ignore_plugin_errors, ignoremissingtypes, ignoreschedules, include_legacy_facts, key_type, keylength, lastrunfile, lastrunreport, ldapattrs, ldapbase, ldapclassattrs, ldapparentattr, ldappassword, ldapport, ldapserver, ldapssl, ldapstackedattrs, ldapstring, ldaptls, ldapuser, libdir, localcacert, localedest, localesource, location_trusted, log_level, logdest, logdir, manage_internal_file_permissions, manifest, masterport, max_deprecations, max_errors, max_warnings, maximum_uid, maxwaitforcert, maxwaitforlock, merge_dependency_warnings, mkusers, module_groups, module_repository, module_working_dir, modulepath, name, named_curve, no_proxy, node_cache_terminus, node_name, node_name_fact, node_name_value, node_terminus, noop, number_of_facts_soft_limit, onetime, passfile, path, payload_soft_limit, pidfile, plugindest, pluginfactdest, pluginfactsource, pluginsignore, pluginsource, pluginsync, postrun_command, preferred_serialization_format, preprocess_deferred, prerun_command, preview_outputdir, priority, privatedir, privatekeydir, profile, publicdir, publickeydir, puppet_trace, puppetdlog, report, report_configured_environmentpath, report_include_system_store, report_port, report_server, reportdir, reports, reporturl, requestdir, resourcefile, rest_authconfig, resubmit_facts, rich_data, route_file, rundir, runinterval, runtimeout, serial, server, server_datadir, server_list, serverport, settings_catalog, show_diff, signeddir, skip_tags, sourceaddress, splay, splaylimit, srv_domain, ssl_client_ca_auth, ssl_client_header, ssl_client_verify_header, ssl_lockfile, ssl_server_ca_auth, ssl_trust_store, ssldir, statedir, statefile, statettl, static_catalogs, storeconfigs, storeconfigs_backend, strict, strict_environment_mode, strict_hostname_checking, strict_variables, summarize, supported_checksum_types, syslogfacility, tags, tasks, top_level_facts_soft_limit, trace, transactionstorefile, trusted_external_command, trusted_oid_mapping_file, use_cached_catalog, use_last_environment, use_srv_records, usecacheonfailure, user, vardir, vendormoduledir, versioned_environment_dirs, waitforcert, waitforlock, write_catalog_summary, yamldir]`

## Tasks

### <a name="delete_local_filebucket"></a>`delete_local_filebucket`

Removes the local filebucket

**Supports noop?** false

#### Parameters

##### `force`

Data type: `Optional[Boolean]`

ignore nonexistent files and errors

### <a name="facts_diff"></a>`facts_diff`

Run the Puppet agent facts diff action

**Supports noop?** false

#### Parameters

##### `exclude`

Data type: `Optional[String]`

Regex used to exclude specific facts from diff

### <a name="install"></a>`install`

Install the Puppet agent package

**Supports noop?** true

#### Parameters

##### `version`

Data type: `Optional[String]`

The version of puppet-agent to install (defaults to latest when no agent is installed)

##### `collection`

Data type: `Optional[Enum[puppet7, puppet8, puppet, puppet7-nightly, puppet8-nightly, puppet-nightly, puppetcore7, puppetcore8]]`

The Puppet collection to install from (defaults to puppet, which maps to the latest collection released)

##### `absolute_source`

Data type: `Optional[String]`

The absolute source location to find the Puppet agent package

##### `yum_source`

Data type: `Optional[String]`

The source location to find yum repos (defaults to yum.puppet.com)

##### `apt_source`

Data type: `Optional[String]`

The source location to find apt repos (defaults to apt.puppet.com)

##### `mac_source`

Data type: `Optional[String]`

The source location to find mac packages (defaults to downloads.puppet.com)

##### `windows_source`

Data type: `Optional[String]`

The source location to find windows packages (defaults to downloads.puppet.com)

##### `install_options`

Data type: `Optional[String]`

optional install arguments to the windows installer (defaults to REINSTALLMODE="amus")

##### `stop_service`

Data type: `Optional[Boolean]`

Whether to stop the puppet agent service after install

##### `retry`

Data type: `Optional[Integer]`

The number of retries in case of network connectivity failures

##### `username`

Data type: `Optional[String]`

The username to use when downloading from a source location requiring authentication

##### `password`

Data type: `Optional[String]`

The password to use when downloading from a source location requiring authentication

### <a name="install_powershell"></a>`install_powershell`

Install the Puppet agent package

**Supports noop?** true

#### Parameters

##### `version`

Data type: `Optional[String]`

The version of puppet-agent to install

##### `collection`

Data type: `Optional[Enum[puppet7, puppet8, puppet, puppet7-nightly, puppet8-nightly, puppet-nightly]]`

The Puppet collection to install from (defaults to puppet, which maps to the latest collection released)

##### `absolute_source`

Data type: `Optional[String]`

The absolute source location to find the Puppet agent package

##### `yum_source`

Data type: `Optional[String]`

The source location to find yum repos (defaults to yum.puppet.com)

##### `apt_source`

Data type: `Optional[String]`

The source location to find apt repos (defaults to apt.puppet.com)

##### `mac_source`

Data type: `Optional[String]`

The source location to find mac packages (defaults to downloads.puppet.com)

##### `windows_source`

Data type: `Optional[String]`

The source location to find windows packages (defaults to downloads.puppet.com)

##### `install_options`

Data type: `Optional[String]`

optional install arguments to the windows installer (defaults to REINSTALLMODE="amus")

##### `stop_service`

Data type: `Optional[Boolean]`

Whether to stop the puppet agent service after install

##### `retry`

Data type: `Optional[Integer]`

The number of retries in case of network connectivity failures

##### `username`

Data type: `Optional[String[1]]`

The username to use when downloading from a source location requiring authentication

##### `password`

Data type: `Optional[Sensitive[String[1]]]`

The password to use when downloading from a source location requiring authentication

### <a name="install_shell"></a>`install_shell`

Install the Puppet agent package

**Supports noop?** true

#### Parameters

##### `version`

Data type: `Optional[String]`

The version of puppet-agent to install

##### `collection`

Data type: `Optional[Enum[puppet7, puppet8, puppet, puppet7-nightly, puppet8-nightly, puppet-nightly, puppetcore7, puppetcore8]]`

The Puppet collection to install from (defaults to puppet, which maps to the latest collection released)

##### `absolute_source`

Data type: `Optional[String]`

The absolute source location to find the Puppet agent package

##### `yum_source`

Data type: `Optional[String]`

The source location to find yum repos (defaults to yum.puppet.com)

##### `apt_source`

Data type: `Optional[String]`

The source location to find apt repos (defaults to apt.puppet.com)

##### `mac_source`

Data type: `Optional[String]`

The source location to find mac packages (defaults to downloads.puppet.com)

##### `windows_source`

Data type: `Optional[String]`

The source location to find windows packages (defaults to downloads.puppet.com)

##### `install_options`

Data type: `Optional[String]`

optional install arguments to the windows installer (defaults to REINSTALLMODE="amus")

##### `stop_service`

Data type: `Optional[Boolean]`

Whether to stop the puppet agent service after install

##### `retry`

Data type: `Optional[Integer]`

The number of retries in case of network connectivity failures

##### `username`

Data type: `Optional[String[1]]`

The username to use when downloading from a source location requiring authentication

##### `password`

Data type: `Optional[Sensitive[String[1]]]`

The password to use when downloading from a source location requiring authentication

### <a name="run"></a>`run`

Run the Puppet agent. This task may cause problems if run in Puppet Enterprise.

**Supports noop?** false

#### Parameters

##### `noop`

Data type: `Boolean`

run the puppet agent with --noop

##### `environment`

Data type: `Optional[String[1]]`

The desired puppet code environment to use

##### `tags`

Data type: `Optional[Variant[String[1],Array[String[1]]]]`

Optional tag or array of tags that will be passed to --tags

### <a name="version"></a>`version`

Get the version of the Puppet agent package installed. Returns nothing if none present.

**Supports noop?** false

### <a name="version_powershell"></a>`version_powershell`

Get the version of the Puppet agent package installed. Returns nothing if none present.

**Supports noop?** false

### <a name="version_shell"></a>`version_shell`

Get the version of the Puppet agent package installed. Returns nothing if none present.

**Supports noop?** false

## Plans

### <a name="puppet_agent--run"></a>`puppet_agent::run`

Starts a Puppet agent run on the specified targets.
Note: This plan may cause issues when run in Puppet Enterprise.

#### Parameters

The following parameters are available in the `puppet_agent::run` plan:

* [`targets`](#-puppet_agent--run--targets)
* [`noop`](#-puppet_agent--run--noop)
* [`environment`](#-puppet_agent--run--environment)
* [`tags`](#-puppet_agent--run--tags)

##### <a name="-puppet_agent--run--targets"></a>`targets`

Data type: `TargetSpec`

The targets to start a Puppet agent run on.

##### <a name="-puppet_agent--run--noop"></a>`noop`

Data type: `Boolean`

if true, all runs will use --noop

Default value: `false`

##### <a name="-puppet_agent--run--environment"></a>`environment`

Data type: `Optional[String[1]]`

the desired puppet code environment

Default value: `undef`

##### <a name="-puppet_agent--run--tags"></a>`tags`

Data type: `Optional[Variant[String[1],Array[String[1]]]]`

an optional string that will be passed to --tags

Default value: `undef`

