# frozen_string_literal: true

# THIS IS A PE SPECIFIC IMPLEMENTATION OF FILE::WRITE: THIS IMPLEMENTATION WILL OVERRIDE THE ONE
# THAT COMES WITH A BOLT INSTALLATION
#
# Open-source bolt implementation:
# https://github.com/puppetlabs/bolt/blob/master/bolt-modules/file/lib/puppet/functions/file/write.rb
#
# file::write for plans-in-PE will return an error since it is not needed in the current iteration
# of plans in PE.
Puppet::Functions.create_function(:'file::write') do
  dispatch :write do
    required_param 'String', :filename
    required_param 'String', :content
    return_type 'Undef'
  end

  def write(filename, content)
    raise Puppet::Error, "file::write is currently not supported in PE plans"
  end
end
