# Puppet Enterprise Management Tools

This repository is one of several that comprise the tooling used to manage
installations of Puppet Enterprise.

The index of repositories and documentation for these tools is at
[puppetlabs/pe-installer-shim](https://github.com/puppetlabs/pe-installer-shim).


## Development

The various scriptlets used by the old puppet-enterprise-installer script that
lives in [pe-installer-shim](https://github.com/puppetlabs/pe-installer-shim)
are found in the [exe](./exe) directory. All of these are installed into the
gem executable path when the `pe_installer` module is installed into the
pe-installer package.

The [pe-admin-design.md doc](./docs/pe-admin-design.md) has notes about some
prototype work that was done some years back for newer tooling to replace the
`puppet-enterprise-installer`/`pupet infra configure` toolchain with a Bolt
based install process.

## Testing

To run specs and lint checks:

```
bundle install
bundle exec rake
```

## Releasing

At the moment we're not releasing `pe_installer` as a gem. It is just a component
of the pe-installer package.

## Contributing

Pull requests are welcome on GitHub at https://github.com/puppetlabs/pe_installer.

This project is intended to be a safe, welcoming space for collaboration, and
contributors are expected to adhere to the [Contributor
Covenant](http://contributor-covenant.org) code of conduct.

## Code of Conduct

Everyone interacting in the PeInstaller project’s codebases, issue trackers,
chat rooms and mailing lists is expected to follow the [code of
conduct](https://github.com/puppetlabs/pe_installer/blob/main/CODE_OF_CONDUCT.md).
