#!/opt/puppetlabs/installer/bin/ruby
require 'open3'

# Check for postgresql11 after an upgrade is complete
# The pe_postgresql_info fact isn't yet updated, so we can't rely on that without first running puppet, which isn't an option
# This uses the existence of the datadir instead

pg11_datadir = "/opt/puppetlabs/server/data/postgresql/11"
return if !Dir.exist? pg11_datadir

pg94_bytes_string = Open3.capture2e('facter -p \'pe_postgresql_info.versions."9.4".used_bytes\'')[0].strip
pg94_bytes = pg94_bytes_string.to_f if pg94_bytes_string
pg94_gb = (pg94_bytes/10**9).round(2)

pg96_bytes_string = Open3.capture2e('facter -p \'pe_postgresql_info.versions."9.6".used_bytes\'')[0].strip
pg96_bytes = pg96_bytes_string.to_f if pg96_bytes_string
pg96_gb = (pg96_bytes/10**9).round(2)

return if !(pg94_gb > 0 || pg96_gb > 0)

puts
puts "Your PE PostgreSQL 9.4 directories are currently taking up #{pg94_gb} gigabytes." if pg94_gb > 0
puts "Your PE PostgreSQL 9.6 directories are currently taking up #{pg96_gb} gigabytes." if pg96_gb > 0
puts 'Your PE installation is now running PostgreSQL 11. You can optionally remove packages and data associated with previous PostgreSQL versions with the command "puppet infrastructure run remove_old_postgresql_versions".'
