# frozen_string_literal: true

module PeInstaller

  # Handles user output.
  class Reporter
    attr_accessor :config

    def initialize(config)
      self.config = config
    end

    def detail(*args)
      pp args
    end

    def result(*args)
      pp args
    end

    def step_error(error)
      error.step_errors.each do |e|
        pp e.value
      end
    end
  end
end
