# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`apt`](#apt): Main class, includes all other classes.
* [`apt::backports`](#apt--backports): Manages backports.

#### Private Classes

* `apt::update`: Updates the list of available packages using apt-get update.

### Defined types

* [`apt::conf`](#apt--conf): Specifies a custom Apt configuration file.
* [`apt::key`](#apt--key): Manages the GPG keys that Apt uses to authenticate packages.
* [`apt::keyring`](#apt--keyring): Manage GPG keyrings for apt repositories
* [`apt::mark`](#apt--mark): Manages apt-mark settings
* [`apt::pin`](#apt--pin): Manages Apt pins. Does not trigger an apt-get update run.
* [`apt::ppa`](#apt--ppa): Manages PPA repositories using `add-apt-repository`. Not supported on Debian.
* [`apt::setting`](#apt--setting): Manages Apt configuration files.
* [`apt::source`](#apt--source): Manages the Apt sources in /etc/apt/sources.list.d/.

### Resource types

#### Private Resource types

* `apt_key`: This type provides Puppet with the capabilities to manage GPG keys needed
by apt to perform package validation. Apt has it's own GPG keyring that can
be manipulated through the `apt-key` command.

### Data types

* [`Apt::Auth_conf_entry`](#Apt--Auth_conf_entry): Login configuration settings that are recorded in the file `/etc/apt/auth.conf`.
* [`Apt::Proxy`](#Apt--Proxy): Configures Apt to connect to a proxy server.
* [`Apt::Proxy_Per_Host`](#Apt--Proxy_Per_Host): Adds per-host overrides to the system default APT proxy configuration

### Tasks

* [`init`](#init): Allows you to perform apt-get functions

## Classes

### <a name="apt"></a>`apt`

Main class, includes all other classes.

* **See also**
  * https://docs.puppetlabs.com/references/latest/function.html#createresources
    * for the create resource function

#### Parameters

The following parameters are available in the `apt` class:

* [`provider`](#-apt--provider)
* [`keyserver`](#-apt--keyserver)
* [`key_options`](#-apt--key_options)
* [`ppa_options`](#-apt--ppa_options)
* [`ppa_package`](#-apt--ppa_package)
* [`backports`](#-apt--backports)
* [`confs`](#-apt--confs)
* [`update`](#-apt--update)
* [`update_defaults`](#-apt--update_defaults)
* [`purge`](#-apt--purge)
* [`purge_defaults`](#-apt--purge_defaults)
* [`proxy`](#-apt--proxy)
* [`proxy_defaults`](#-apt--proxy_defaults)
* [`sources`](#-apt--sources)
* [`keys`](#-apt--keys)
* [`keyrings`](#-apt--keyrings)
* [`ppas`](#-apt--ppas)
* [`pins`](#-apt--pins)
* [`settings`](#-apt--settings)
* [`manage_auth_conf`](#-apt--manage_auth_conf)
* [`auth_conf_entries`](#-apt--auth_conf_entries)
* [`auth_conf_owner`](#-apt--auth_conf_owner)
* [`root`](#-apt--root)
* [`sources_list`](#-apt--sources_list)
* [`sources_list_d`](#-apt--sources_list_d)
* [`conf_d`](#-apt--conf_d)
* [`preferences`](#-apt--preferences)
* [`preferences_d`](#-apt--preferences_d)
* [`config_files`](#-apt--config_files)
* [`sources_list_force`](#-apt--sources_list_force)
* [`include_defaults`](#-apt--include_defaults)
* [`apt_conf_d`](#-apt--apt_conf_d)
* [`source_key_defaults`](#-apt--source_key_defaults)

##### <a name="-apt--provider"></a>`provider`

Data type: `Stdlib::Absolutepath`

Specifies the provider that should be used by apt::update.

Default value: `'/usr/bin/apt-get'`

##### <a name="-apt--keyserver"></a>`keyserver`

Data type: `Stdlib::Host`

Specifies a keyserver to provide the GPG key. Valid options: a string containing a domain name or a full URL (http://, https://, or
hkp://).

Default value: `'keyserver.ubuntu.com'`

##### <a name="-apt--key_options"></a>`key_options`

Data type: `Optional[String[1]]`

Specifies the default options for apt::key resources.

Default value: `undef`

##### <a name="-apt--ppa_options"></a>`ppa_options`

Data type: `Optional[Array[String[1]]]`

Supplies options to be passed to the `add-apt-repository` command.

Default value: `undef`

##### <a name="-apt--ppa_package"></a>`ppa_package`

Data type: `Optional[String[1]]`

Names the package that provides the `apt-add-repository` command.

Default value: `undef`

##### <a name="-apt--backports"></a>`backports`

Data type: `Optional[Hash]`

Specifies some of the default parameters used by apt::backports. Valid options: a hash made up from the following keys:

Options:

* **:location** `String`: See apt::backports for documentation.
* **:repos** `String`: See apt::backports for documentation.
* **:key** `String`: See apt::backports for documentation.

Default value: `undef`

##### <a name="-apt--confs"></a>`confs`

Data type: `Hash`

Hash of `apt::conf` resources.

Default value: `{}`

##### <a name="-apt--update"></a>`update`

Data type: `Hash`

Configures various update settings. Valid options: a hash made up from the following keys:

Options:

* **:frequency** `String`: Specifies how often to run `apt-get update`. If the exec resource `apt_update` is notified,
`apt-get update` runs regardless of this value.
Valid options:
  'always' (at every Puppet run);
  'hourly' (if the value of `apt_update_last_success` is less than current epoch time minus 3600);
  'daily'  (if the value of `apt_update_last_success` is less than current epoch time minus 86400);
  'weekly' (if the value of `apt_update_last_success` is less than current epoch time minus 604800);
  Integer  (if the value of `apt_update_last_success` is less than current epoch time minus provided Integer value);
  'reluctantly' (only if the exec resource `apt_update` is notified).
Default: 'reluctantly'.
* **:loglevel** `Integer`: Specifies the log level of logs outputted to the console. Default: undef.
* **:timeout** `Integer`: Specifies how long to wait for the update to complete before canceling it. Valid options: an integer, in seconds. Default: undef.
* **:tries** `Integer`: Specifies how many times to retry the update after receiving a DNS or HTTP error. Default: undef.

Default value: `{}`

##### <a name="-apt--update_defaults"></a>`update_defaults`

Data type: `Hash`

The default update settings that are combined and merged with the passed `update` value

Default value:

```puppet
{
    'frequency' => 'reluctantly',
    'loglevel'  => undef,
    'timeout'   => undef,
    'tries'     => undef,
  }
```

##### <a name="-apt--purge"></a>`purge`

Data type: `Hash`

Specifies whether to purge any existing settings that aren't managed by Puppet. Valid options: a hash made up from the following keys:

Options:

* **:sources.list** `Boolean`: Specifies whether to purge any unmanaged entries from sources.list. Default false.
* **:sources.list.d** `Boolean`: Specifies whether to purge any unmanaged entries from sources.list.d. Default false.
* **:preferences** `Boolean`: Specifies whether to purge any unmanaged entries from preferences. Default false.
* **:preferences.d.** `Boolean`: Specifies whether to purge any unmanaged entries from preferences.d. Default false.

Default value: `{}`

##### <a name="-apt--purge_defaults"></a>`purge_defaults`

Data type: `Hash`

The default purge settings that are combined and merged with the passed `purge` value

Default value:

```puppet
{
    'sources.list'   => false,
    'sources.list.d' => false,
    'preferences'    => false,
    'preferences.d'  => false,
    'apt.conf.d'     => false,
  }
```

##### <a name="-apt--proxy"></a>`proxy`

Data type: `Apt::Proxy`

Configures Apt to connect to a proxy server. Valid options: a hash matching the locally defined type apt::proxy.

Default value: `{}`

##### <a name="-apt--proxy_defaults"></a>`proxy_defaults`

Data type: `Hash`

The default proxy settings that are combined and merged with the passed `proxy` value

Default value:

```puppet
{
    'ensure'     => undef,
    'host'       => undef,
    'port'       => 8080,
    'https'      => false,
    'https_acng' => false,
    'direct'     => false,
  }
```

##### <a name="-apt--sources"></a>`sources`

Data type: `Hash`

Hash of `apt::source` resources.

Default value: `{}`

##### <a name="-apt--keys"></a>`keys`

Data type: `Hash`

Hash of `apt::key` resources.

Default value: `{}`

##### <a name="-apt--keyrings"></a>`keyrings`

Data type: `Hash`

Hash of `apt::keyring` resources.

Default value: `{}`

##### <a name="-apt--ppas"></a>`ppas`

Data type: `Hash`

Hash of `apt::ppa` resources.

Default value: `{}`

##### <a name="-apt--pins"></a>`pins`

Data type: `Hash`

Hash of `apt::pin` resources.

Default value: `{}`

##### <a name="-apt--settings"></a>`settings`

Data type: `Hash`

Hash of `apt::setting` resources.

Default value: `{}`

##### <a name="-apt--manage_auth_conf"></a>`manage_auth_conf`

Data type: `Boolean`

Specifies whether to manage the /etc/apt/auth.conf file. When true, the file will be overwritten with the entries specified in
the auth_conf_entries parameter. When false, the file will be ignored (note that this does not set the file to absent.

Default value: `true`

##### <a name="-apt--auth_conf_entries"></a>`auth_conf_entries`

Data type: `Array[Apt::Auth_conf_entry]`

An optional array of login configuration settings (hashes) that are recorded in the file /etc/apt/auth.conf. This file has a netrc-like
format (similar to what curl uses) and contains the login configuration for APT sources and proxies that require authentication. See
https://manpages.debian.org/testing/apt/apt_auth.conf.5.en.html for details. If specified each hash must contain the keys machine, login and
password and no others. Specifying manage_auth_conf and not specifying this parameter will set /etc/apt/auth.conf to absent.

Default value: `[]`

##### <a name="-apt--auth_conf_owner"></a>`auth_conf_owner`

Data type: `String[1]`

The owner of the file /etc/apt/auth.conf.

Default value: `'_apt'`

##### <a name="-apt--root"></a>`root`

Data type: `Stdlib::Absolutepath`

Specifies root directory of Apt executable.

Default value: `'/etc/apt'`

##### <a name="-apt--sources_list"></a>`sources_list`

Data type: `Stdlib::Absolutepath`

Specifies the path of the sources_list file to use.

Default value: `"${root}/sources.list"`

##### <a name="-apt--sources_list_d"></a>`sources_list_d`

Data type: `Stdlib::Absolutepath`

Specifies the path of the sources_list.d file to use.

Default value: `"${root}/sources.list.d"`

##### <a name="-apt--conf_d"></a>`conf_d`

Data type: `Stdlib::Absolutepath`

Specifies the path of the conf.d file to use.

Default value: `"${root}/apt.conf.d"`

##### <a name="-apt--preferences"></a>`preferences`

Data type: `Stdlib::Absolutepath`

Specifies the path of the preferences file to use.

Default value: `"${root}/preferences"`

##### <a name="-apt--preferences_d"></a>`preferences_d`

Data type: `Stdlib::Absolutepath`

Specifies the path of the preferences.d file to use.

Default value: `"${root}/preferences.d"`

##### <a name="-apt--config_files"></a>`config_files`

Data type: `Hash`

A hash made up of the various configuration files used by Apt.

Default value:

```puppet
{
    'conf'   => {
      'path' => $conf_d,
      'ext'  => '',
    },
    'pref'   => {
      'path' => $preferences_d,
      'ext'  => '.pref',
    },
    'list'   => {
      'path' => $sources_list_d,
      'ext'  => '.list',
    },
    'sources' => {
      'path' => $sources_list_d,
      'ext'  => '.sources',
    },
  }
```

##### <a name="-apt--sources_list_force"></a>`sources_list_force`

Data type: `Boolean`

Specifies whether to perform force purge or delete.

Default value: `false`

##### <a name="-apt--include_defaults"></a>`include_defaults`

Data type: `Hash`

The package types to include by default.

Default value:

```puppet
{
    'deb' => true,
    'src' => false,
  }
```

##### <a name="-apt--apt_conf_d"></a>`apt_conf_d`

Data type: `Stdlib::Absolutepath`

The path to the file `apt.conf.d`

Default value: `"${root}/apt.conf.d"`

##### <a name="-apt--source_key_defaults"></a>`source_key_defaults`

Data type: `Hash`

The fault `source_key` settings

Default value:

```puppet
{
    'server'  => $keyserver,
    'options' => undef,
    'content' => undef,
    'source'  => undef,
  }
```

### <a name="apt--backports"></a>`apt::backports`

Manages backports.

#### Examples

##### Set up a backport source for Ubuntu

```puppet
include apt::backports
```

#### Parameters

The following parameters are available in the `apt::backports` class:

* [`location`](#-apt--backports--location)
* [`release`](#-apt--backports--release)
* [`repos`](#-apt--backports--repos)
* [`key`](#-apt--backports--key)
* [`keyring`](#-apt--backports--keyring)
* [`pin`](#-apt--backports--pin)
* [`include`](#-apt--backports--include)

##### <a name="-apt--backports--location"></a>`location`

Data type: `Optional[Stdlib::HTTPUrl]`

Specifies an Apt repository containing the backports to manage. Valid options: a string containing a URL. Default value for Debian and
Ubuntu varies:

- Debian: 'http://deb.debian.org/debian'

- Ubuntu: 'http://archive.ubuntu.com/ubuntu'

Default value: `undef`

##### <a name="-apt--backports--release"></a>`release`

Data type: `Optional[String[1]]`

Specifies a distribution of the Apt repository containing the backports to manage. Used in populating the `sources.list` configuration file.
Default: on Debian and Ubuntu, `${fact('os.distro.codename')}-backports`. We recommend keeping this default, except on other operating
systems.

Default value: `undef`

##### <a name="-apt--backports--repos"></a>`repos`

Data type: `Optional[String[1]]`

Specifies a component of the Apt repository containing the backports to manage. Used in populating the `sources.list` configuration file.
Default value for Debian and Ubuntu varies:

- Debian: 'main contrib non-free non-free-firmware'

- Ubuntu: 'main universe multiverse restricted'

Default value: `undef`

##### <a name="-apt--backports--key"></a>`key`

Data type: `Optional[Variant[String[1], Hash]]`

Specifies a key to authenticate the backports. Valid options: a string to be passed to the id parameter of the apt::key defined type, or a
hash of parameter => value pairs to be passed to apt::key's id, server, content, source, and/or options parameters.

Default value: `undef`

##### <a name="-apt--backports--keyring"></a>`keyring`

Data type: `Stdlib::AbsolutePath`

Absolute path to a file containing the PGP keyring used to sign this
repository. Value is passed to the apt::source and used to set signed-by on
the source entry.

Default value: `"/usr/share/keyrings/${facts['os']['name'].downcase}-archive-keyring.gpg"`

##### <a name="-apt--backports--pin"></a>`pin`

Data type: `Variant[Integer, String[1], Hash]`

Specifies a pin priority for the backports. Valid options: a number or string to be passed to the `id` parameter of the `apt::pin` defined
type, or a hash of `parameter => value` pairs to be passed to `apt::pin`'s corresponding parameters.

Default value: `200`

##### <a name="-apt--backports--include"></a>`include`

Data type: `Hash`

Specifies whether to include 'deb' or 'src', or both.

Default value: `{}`

## Defined types

### <a name="apt--conf"></a>`apt::conf`

Specifies a custom Apt configuration file.

#### Parameters

The following parameters are available in the `apt::conf` defined type:

* [`content`](#-apt--conf--content)
* [`ensure`](#-apt--conf--ensure)
* [`priority`](#-apt--conf--priority)
* [`notify_update`](#-apt--conf--notify_update)

##### <a name="-apt--conf--content"></a>`content`

Data type: `Optional[String[1]]`

Required unless `ensure` is set to 'absent'. Directly supplies content for the configuration file.

Default value: `undef`

##### <a name="-apt--conf--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Specifies whether the configuration file should exist.

Default value: `present`

##### <a name="-apt--conf--priority"></a>`priority`

Data type: `Variant[String[1], Integer[0]]`

Determines the order in which Apt processes the configuration file. Files with lower priority numbers are loaded first.
Valid options: a string containing an integer or an integer.

Default value: `50`

##### <a name="-apt--conf--notify_update"></a>`notify_update`

Data type: `Optional[Boolean]`

Specifies whether to trigger an `apt-get update` run.

Default value: `undef`

### <a name="apt--key"></a>`apt::key`

Manages the GPG keys that Apt uses to authenticate packages.

* **Note** The apt::key defined type makes use of the apt_key type, but includes extra functionality to help prevent duplicate keys.

#### Examples

##### Declare Apt key for apt.puppetlabs.com source

```puppet
apt::key { 'puppetlabs':
  id      => '6F6B15509CF8E59E6E469F327F438280EF8D349F',
  server  => 'keyserver.ubuntu.com',
  options => 'http-proxy="http://proxyuser:proxypass@example.org:3128"',
}
```

#### Parameters

The following parameters are available in the `apt::key` defined type:

* [`id`](#-apt--key--id)
* [`ensure`](#-apt--key--ensure)
* [`content`](#-apt--key--content)
* [`source`](#-apt--key--source)
* [`server`](#-apt--key--server)
* [`weak_ssl`](#-apt--key--weak_ssl)
* [`options`](#-apt--key--options)

##### <a name="-apt--key--id"></a>`id`

Data type: `Pattern[/\A(0x)?[0-9a-fA-F]{8}\Z/, /\A(0x)?[0-9a-fA-F]{16}\Z/, /\A(0x)?[0-9a-fA-F]{40}\Z/]`

Specifies a GPG key to authenticate Apt package signatures. Valid options: a string containing a key ID (8 or 16 hexadecimal
characters, optionally prefixed with "0x") or a full key fingerprint (40 hexadecimal characters).

Default value: `$title`

##### <a name="-apt--key--ensure"></a>`ensure`

Data type: `Enum['present', 'absent', 'refreshed']`

Specifies whether the key should exist. Using `refreshed` will make keys
auto update when they have expired (assuming a new key exists on the key
server).

Default value: `present`

##### <a name="-apt--key--content"></a>`content`

Data type: `Optional[String[1]]`

Supplies the entire GPG key. Useful in case the key can't be fetched from a remote location and using a file resource is inconvenient.

Default value: `undef`

##### <a name="-apt--key--source"></a>`source`

Data type: `Optional[Pattern[/\Ahttps?:\/\//, /\Aftp:\/\//, /\A\/\w+/]]`

Specifies the location of an existing GPG key file to copy. Valid options: a string containing a URL (ftp://, http://, or https://) or
an absolute path.

Default value: `undef`

##### <a name="-apt--key--server"></a>`server`

Data type: `Pattern[/\A((hkp|hkps|http|https):\/\/)?([a-z\d])([a-z\d-]{0,61}\.)+[a-z\d]+(:\d{2,5})?(\/[a-zA-Z\d\-_.]+)*\/?$/]`

Specifies a keyserver to provide the GPG key. Valid options: a string containing a domain name or a full URL (http://, https://,
hkp:// or hkps://). The hkps:// protocol is currently only supported on Ubuntu 18.04.

Default value: `$apt::keyserver`

##### <a name="-apt--key--weak_ssl"></a>`weak_ssl`

Data type: `Boolean`

Specifies whether strict SSL verification on a https URL should be disabled.

Default value: `false`

##### <a name="-apt--key--options"></a>`options`

Data type: `Optional[String[1]]`

Passes additional options to `apt-key adv --keyserver-options`.

Default value: `$apt::key_options`

### <a name="apt--keyring"></a>`apt::keyring`

Manage GPG keyrings for apt repositories

#### Examples

##### Download the puppetlabs apt keyring

```puppet
apt::keyring { 'puppetlabs-keyring.gpg':
  source => 'https://apt.puppetlabs.com/keyring.gpg',
}
```

##### Deploy the apt source and associated keyring file

```puppet
apt::source { 'puppet8-release':
  location => 'http://apt.puppetlabs.com',
  repos    => 'puppet8',
  key      => {
    name   => 'puppetlabs-keyring.gpg',
    source => 'https://apt.puppetlabs.com/keyring.gpg'
  }
}
```

#### Parameters

The following parameters are available in the `apt::keyring` defined type:

* [`dir`](#-apt--keyring--dir)
* [`filename`](#-apt--keyring--filename)
* [`mode`](#-apt--keyring--mode)
* [`source`](#-apt--keyring--source)
* [`content`](#-apt--keyring--content)
* [`ensure`](#-apt--keyring--ensure)

##### <a name="-apt--keyring--dir"></a>`dir`

Data type: `Stdlib::Absolutepath`

Path to the directory where the keyring will be stored.

Default value: `'/etc/apt/keyrings'`

##### <a name="-apt--keyring--filename"></a>`filename`

Data type: `String[1]`

Optional filename for the keyring. It should also contain extension along with the filename.

Default value: `$name`

##### <a name="-apt--keyring--mode"></a>`mode`

Data type: `Stdlib::Filemode`

File permissions of the keyring.

Default value: `'0644'`

##### <a name="-apt--keyring--source"></a>`source`

Data type: `Optional[Stdlib::Filesource]`

Source of the keyring file. Mutually exclusive with 'content'.

Default value: `undef`

##### <a name="-apt--keyring--content"></a>`content`

Data type: `Optional[String[1]]`

Content of the keyring file. Mutually exclusive with 'source'.

Default value: `undef`

##### <a name="-apt--keyring--ensure"></a>`ensure`

Data type: `Enum['present','absent']`

Ensure presence or absence of the resource.

Default value: `'present'`

### <a name="apt--mark"></a>`apt::mark`

Manages apt-mark settings

#### Parameters

The following parameters are available in the `apt::mark` defined type:

* [`setting`](#-apt--mark--setting)

##### <a name="-apt--mark--setting"></a>`setting`

Data type: `Enum['auto','manual','hold','unhold']`

Specifies the behavior of apt in case of no more dependencies installed
https://manpages.debian.org/stable/apt/apt-mark.8.en.html

### <a name="apt--pin"></a>`apt::pin`

Manages Apt pins. Does not trigger an apt-get update run.

* **See also**
  * https://manpages.debian.org/stable/apt/apt_preferences.5.en.html
    * for context on these parameters

#### Parameters

The following parameters are available in the `apt::pin` defined type:

* [`ensure`](#-apt--pin--ensure)
* [`explanation`](#-apt--pin--explanation)
* [`order`](#-apt--pin--order)
* [`packages`](#-apt--pin--packages)
* [`priority`](#-apt--pin--priority)
* [`release`](#-apt--pin--release)
* [`release_version`](#-apt--pin--release_version)
* [`component`](#-apt--pin--component)
* [`originator`](#-apt--pin--originator)
* [`label`](#-apt--pin--label)
* [`origin`](#-apt--pin--origin)
* [`version`](#-apt--pin--version)
* [`codename`](#-apt--pin--codename)

##### <a name="-apt--pin--ensure"></a>`ensure`

Data type: `Enum['file', 'present', 'absent']`

Specifies whether the pin should exist.

Default value: `present`

##### <a name="-apt--pin--explanation"></a>`explanation`

Data type: `Optional[String[1]]`

Supplies a comment to explain the pin. Default: "${caller_module_name}: ${name}".

Default value: `undef`

##### <a name="-apt--pin--order"></a>`order`

Data type: `Variant[Integer[0]]`

Determines the order in which Apt processes the pin file. Files with lower order numbers are loaded first.

Default value: `50`

##### <a name="-apt--pin--packages"></a>`packages`

Data type: `Variant[String[1], Array[String[1]]]`

Specifies which package(s) to pin.

Default value: `'*'`

##### <a name="-apt--pin--priority"></a>`priority`

Data type: `Variant[Integer, String[1]]`

Sets the priority of the package. If multiple versions of a given package are available, `apt-get` installs the one with the highest
priority number (subject to dependency constraints).

Default value: `0`

##### <a name="-apt--pin--release"></a>`release`

Data type: `Optional[String[1]]`

Tells APT to prefer packages that support the specified release. Typical values include 'stable', 'testing', and 'unstable'.

Default value: `undef`

##### <a name="-apt--pin--release_version"></a>`release_version`

Data type: `Optional[String[1]]`

Tells APT to prefer packages that support the specified operating system release version (such as Debian release version 7).

Default value: `undef`

##### <a name="-apt--pin--component"></a>`component`

Data type: `Optional[String[1]]`

Names the licensing component associated with the packages in the directory tree of the Release file.

Default value: `undef`

##### <a name="-apt--pin--originator"></a>`originator`

Data type: `Optional[String[1]]`

Names the originator of the packages in the directory tree of the Release file.

Default value: `undef`

##### <a name="-apt--pin--label"></a>`label`

Data type: `Optional[String[1]]`

Names the label of the packages in the directory tree of the Release file.

Default value: `undef`

##### <a name="-apt--pin--origin"></a>`origin`

Data type: `Optional[String[1]]`

The package origin (the hostname part of the package's sources.list entry)

Default value: `undef`

##### <a name="-apt--pin--version"></a>`version`

Data type: `Optional[String[1]]`

The version of the package

Default value: `undef`

##### <a name="-apt--pin--codename"></a>`codename`

Data type: `Optional[String[1]]`

The codename of the release

Default value: `undef`

### <a name="apt--ppa"></a>`apt::ppa`

Manages PPA repositories using `add-apt-repository`. Not supported on Debian.

#### Examples

##### Declaration of an Apt PPA

```puppet
apt::ppa { 'ppa:openstack-ppa/bleeding-edge': }
```

#### Parameters

The following parameters are available in the `apt::ppa` defined type:

* [`ensure`](#-apt--ppa--ensure)
* [`options`](#-apt--ppa--options)
* [`release`](#-apt--ppa--release)
* [`dist`](#-apt--ppa--dist)
* [`package_name`](#-apt--ppa--package_name)
* [`package_manage`](#-apt--ppa--package_manage)

##### <a name="-apt--ppa--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Specifies whether the PPA should exist.

Default value: `'present'`

##### <a name="-apt--ppa--options"></a>`options`

Data type: `Optional[Array[String[1]]]`

Supplies options to be passed to the `add-apt-repository` command.

Default value: `$apt::ppa_options`

##### <a name="-apt--ppa--release"></a>`release`

Data type: `Optional[String[1]]`

Specifies the operating system of your node. Valid options: a string containing a valid LSB distribution codename.
Optional if `puppet facts show os.distro.codename` returns your correct distribution release codename.

Default value: `fact('os.distro.codename')`

##### <a name="-apt--ppa--dist"></a>`dist`

Data type: `Optional[String[1]]`

Specifies the distribution of your node. Valid options: a string containing a valid distribution codename.
Optional if `puppet facts show os.name` returns your correct distribution name.

Default value: `$facts['os']['name']`

##### <a name="-apt--ppa--package_name"></a>`package_name`

Data type: `Optional[String[1]]`

Names the package that provides the `apt-add-repository` command.

Default value: `$apt::ppa_package`

##### <a name="-apt--ppa--package_manage"></a>`package_manage`

Data type: `Boolean`

Specifies whether Puppet should manage the package that provides `apt-add-repository`.

Default value: `false`

### <a name="apt--setting"></a>`apt::setting`

Manages Apt configuration files.

* **See also**
  * https://www.puppet.com/docs/puppet/latest/types/file.html#file-attributes
    * for more information on source and content parameters

#### Parameters

The following parameters are available in the `apt::setting` defined type:

* [`priority`](#-apt--setting--priority)
* [`ensure`](#-apt--setting--ensure)
* [`source`](#-apt--setting--source)
* [`content`](#-apt--setting--content)
* [`notify_update`](#-apt--setting--notify_update)

##### <a name="-apt--setting--priority"></a>`priority`

Data type: `Variant[String[1], Integer[0]]`

Determines the order in which Apt processes the configuration file. Files with higher priority numbers are loaded first.

Default value: `50`

##### <a name="-apt--setting--ensure"></a>`ensure`

Data type: `Enum['file', 'present', 'absent']`

Specifies whether the file should exist.

Default value: `file`

##### <a name="-apt--setting--source"></a>`source`

Data type: `Optional[String[1]]`

Required, unless `content` is set. Specifies a source file to supply the content of the configuration file. Cannot be used in combination
with `content`. Valid options: see link above for Puppet's native file type source attribute.

Default value: `undef`

##### <a name="-apt--setting--content"></a>`content`

Data type: `Optional[String[1]]`

Required, unless `source` is set. Directly supplies content for the configuration file. Cannot be used in combination with `source`. Valid
options: see link above for Puppet's native file type content attribute.

Default value: `undef`

##### <a name="-apt--setting--notify_update"></a>`notify_update`

Data type: `Boolean`

Specifies whether to trigger an `apt-get update` run.

Default value: `true`

### <a name="apt--source"></a>`apt::source`

Manages the Apt sources in /etc/apt/sources.list.d/.

#### Examples

##### Install the puppetlabs apt source

```puppet
apt::source { 'puppetlabs':
  location => 'http://apt.puppetlabs.com',
  repos    => 'main',
  key      => {
    id     => '6F6B15509CF8E59E6E469F327F438280EF8D349F',
    server => 'keyserver.ubuntu.com',
  },
}
```

##### Download key behaviour to handle modern apt gpg keyrings. The `name` parameter in the key hash should be given with

```puppet
extension. Absence of extension will result in file formation with just name and no extension.
apt::source { 'puppetlabs':
  location => 'http://apt.puppetlabs.com',
  comment  => 'Puppet8',
  key      => {
    'name'   => 'puppetlabs.gpg',
    'source' => 'https://apt.puppetlabs.com/keyring.gpg',
  },
}
```

##### Install the puppetlabs apt source (deb822 format)

```puppet
apt::source { 'puppetlabs':
  source_format => 'sources'
  location      => ['http://apt.puppetlabs.com'],
  repos         => ['puppet8'],
  keyring       => '/etc/apt/keyrings/puppetlabs.gpg',
}
```

#### Parameters

The following parameters are available in the `apt::source` defined type:

* [`source_format`](#-apt--source--source_format)
* [`location`](#-apt--source--location)
* [`types`](#-apt--source--types)
* [`enabled`](#-apt--source--enabled)
* [`comment`](#-apt--source--comment)
* [`ensure`](#-apt--source--ensure)
* [`release`](#-apt--source--release)
* [`repos`](#-apt--source--repos)
* [`include`](#-apt--source--include)
* [`key`](#-apt--source--key)
* [`keyring`](#-apt--source--keyring)
* [`pin`](#-apt--source--pin)
* [`architecture`](#-apt--source--architecture)
* [`allow_unsigned`](#-apt--source--allow_unsigned)
* [`allow_insecure`](#-apt--source--allow_insecure)
* [`notify_update`](#-apt--source--notify_update)
* [`check_valid_until`](#-apt--source--check_valid_until)

##### <a name="-apt--source--source_format"></a>`source_format`

Data type: `Enum['list', 'sources']`

The file format to use for the apt source. See https://wiki.debian.org/SourcesList

Default value: `'list'`

##### <a name="-apt--source--location"></a>`location`

Data type: `Optional[Variant[String[1], Array[String[1]]]]`

Required, unless ensure is set to 'absent'. Specifies an Apt repository. Valid options: a string containing a repository URL.
DEB822: Supports an array of URL values

Default value: `undef`

##### <a name="-apt--source--types"></a>`types`

Data type: `Array[Enum['deb','deb-src'], 1, 2]`

DEB822: The package types this source manages.

Default value: `['deb']`

##### <a name="-apt--source--enabled"></a>`enabled`

Data type: `Boolean`

DEB822: Enable or Disable the APT source.

Default value: `true`

##### <a name="-apt--source--comment"></a>`comment`

Data type: `String[1]`

Supplies a comment for adding to the Apt source file.

Default value: `$name`

##### <a name="-apt--source--ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

Specifies whether the Apt source file should exist.

Default value: `present`

##### <a name="-apt--source--release"></a>`release`

Data type: `Optional[Variant[String[0], Array[String[0]]]]`

Specifies a distribution of the Apt repository.
DEB822: Supports an array of values

Default value: `undef`

##### <a name="-apt--source--repos"></a>`repos`

Data type: `Variant[String[1], Array[String[1]]]`

Specifies a component of the Apt repository.
DEB822: Supports an array of values

Default value: `'main'`

##### <a name="-apt--source--include"></a>`include`

Data type: `Hash`

Configures include options. Valid options: a hash of available keys.

Options:

* **:deb** `Boolean`: Specifies whether to request the distribution's compiled binaries.
* **:src** `Boolean`: Specifies whether to request the distribution's uncompiled source code.

Default value: `{}`

##### <a name="-apt--source--key"></a>`key`

Data type: `Optional[Variant[String[1], Hash]]`

Creates an `apt::keyring` in `/etc/apt/keyrings` (or anywhere on disk given `filename`) Valid options:
  * a hash of `parameter => value` pairs to be passed to `file`: `name` (title), `content`, `source`, `filename`

The following inputs are valid for the (deprecated) `apt::key` defined type. Valid options:
  * a string to be passed to the `id` parameter of the `apt::key` defined type
  * a hash of `parameter => value` pairs to be passed to `apt::key`: `id`, `server`, `content`, `source`, `weak_ssl`, `options`

Default value: `undef`

##### <a name="-apt--source--keyring"></a>`keyring`

Data type: `Optional[Stdlib::AbsolutePath]`

Absolute path to a file containing the PGP keyring used to sign this repository. Value is used to set signed-by on the source entry.
This is not necessary if the key is installed with `key` param above.
See https://wiki.debian.org/DebianRepository/UseThirdParty for details.

Default value: `undef`

##### <a name="-apt--source--pin"></a>`pin`

Data type: `Optional[Variant[Hash, Integer, String[1]]]`

Creates a declaration of the apt::pin defined type. Valid options: a number or string to be passed to the `priority` parameter of the
`apt::pin` defined type, or a hash of `parameter => value` pairs to be passed to `apt::pin`'s corresponding parameters.

Default value: `undef`

##### <a name="-apt--source--architecture"></a>`architecture`

Data type: `Optional[Variant[String[1], Array[String[1]]]]`

Tells Apt to only download information for specified architectures. Valid options: a string containing one or more architecture names,
separated by commas (e.g., 'i386' or 'i386,alpha,powerpc').
(if unspecified, Apt downloads information for all architectures defined in the Apt::Architectures option)
DEB822: Supports an array of values

Default value: `undef`

##### <a name="-apt--source--allow_unsigned"></a>`allow_unsigned`

Data type: `Optional[Boolean]`

Specifies whether to authenticate packages from this release, even if the Release file is not signed or the signature can't be checked.

Default value: `undef`

##### <a name="-apt--source--allow_insecure"></a>`allow_insecure`

Data type: `Optional[Boolean]`

Specifies whether to allow downloads from insecure repositories.

Default value: `undef`

##### <a name="-apt--source--notify_update"></a>`notify_update`

Data type: `Boolean`

Specifies whether to trigger an `apt-get update` run.

Default value: `true`

##### <a name="-apt--source--check_valid_until"></a>`check_valid_until`

Data type: `Optional[Boolean]`

Specifies whether to check if the package release date is valid.

Default value: `undef`

## Data types

### <a name="Apt--Auth_conf_entry"></a>`Apt::Auth_conf_entry`

Login configuration settings that are recorded in the file `/etc/apt/auth.conf`.

* **See also**
  * https://manpages.debian.org/testing/apt/apt_auth.conf.5.en.html
  * for more information

Alias of

```puppet
Struct[{
    machine => String[1],
    login => String,
    password => String
  }]
```

#### Parameters

The following parameters are available in the `Apt::Auth_conf_entry` data type:

* [`machine`](#-Apt--Auth_conf_entry--machine)
* [`login`](#-Apt--Auth_conf_entry--login)
* [`password`](#-Apt--Auth_conf_entry--password)

##### <a name="-Apt--Auth_conf_entry--machine"></a>`machine`

Hostname of machine to connect to.

##### <a name="-Apt--Auth_conf_entry--login"></a>`login`

Specifies the username to connect with.

##### <a name="-Apt--Auth_conf_entry--password"></a>`password`

Specifies the password to connect with.

### <a name="Apt--Proxy"></a>`Apt::Proxy`

Configures Apt to connect to a proxy server.

Alias of

```puppet
Struct[{
    ensure     => Optional[Enum['file', 'present', 'absent']],
    host       => Optional[String],
    port       => Optional[Integer[0, 65535]],
    https      => Optional[Boolean],
    https_acng => Optional[Boolean],
    direct     => Optional[Boolean],
    perhost    => Optional[Array[Apt::Proxy_Per_Host]],
  }]
```

#### Parameters

The following parameters are available in the `Apt::Proxy` data type:

* [`ensure`](#-Apt--Proxy--ensure)
* [`host`](#-Apt--Proxy--host)
* [`port`](#-Apt--Proxy--port)
* [`https`](#-Apt--Proxy--https)
* [`direct`](#-Apt--Proxy--direct)

##### <a name="-Apt--Proxy--ensure"></a>`ensure`

Specifies whether the proxy should exist. Valid options: 'file', 'present', and 'absent'. Prefer 'file' over 'present'.

##### <a name="-Apt--Proxy--host"></a>`host`

Specifies a proxy host to be stored in `/etc/apt/apt.conf.d/01proxy`. Valid options: a string containing a hostname.

##### <a name="-Apt--Proxy--port"></a>`port`

Specifies a proxy port to be stored in `/etc/apt/apt.conf.d/01proxy`. Valid options: an integer containing a port number.

##### <a name="-Apt--Proxy--https"></a>`https`

Specifies whether to enable https proxies.

##### <a name="-Apt--Proxy--direct"></a>`direct`

Specifies whether or not to use a `DIRECT` https proxy if http proxy is used but https is not.

### <a name="Apt--Proxy_Per_Host"></a>`Apt::Proxy_Per_Host`

Adds per-host overrides to the system default APT proxy configuration

Alias of

```puppet
Struct[{
    scope      => String,
    host       => Optional[String],
    port       => Optional[Integer[1, 65535]],
    https      => Optional[Boolean],
    direct     => Optional[Boolean],
  }]
```

#### Parameters

The following parameters are available in the `Apt::Proxy_Per_Host` data type:

* [`scope`](#-Apt--Proxy_Per_Host--scope)
* [`host`](#-Apt--Proxy_Per_Host--host)
* [`port`](#-Apt--Proxy_Per_Host--port)
* [`https`](#-Apt--Proxy_Per_Host--https)
* [`direct`](#-Apt--Proxy_Per_Host--direct)

##### <a name="-Apt--Proxy_Per_Host--scope"></a>`scope`

Specifies the scope of the override.  Valid options: a string containing a hostname.

##### <a name="-Apt--Proxy_Per_Host--host"></a>`host`

Specifies a proxy host to be stored in `/etc/apt/apt.conf.d/01proxy`. Valid options: a string containing a hostname.

##### <a name="-Apt--Proxy_Per_Host--port"></a>`port`

Specifies a proxy port to be stored in `/etc/apt/apt.conf.d/01proxy`. Valid options: an integer containing a port number.

##### <a name="-Apt--Proxy_Per_Host--https"></a>`https`

Specifies whether to enable https for this override.

##### <a name="-Apt--Proxy_Per_Host--direct"></a>`direct`

Specifies whether or not to use a `DIRECT` target to bypass the system default proxy.

## Tasks

### <a name="init"></a>`init`

Allows you to perform apt-get functions

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[update, upgrade, dist-upgrade, autoremove]`

Action to perform with apt-get

