# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Tasks

* [`init`](#init): Bootstrap a node with puppet-agent
* [`linux`](#linux): Bootstrap a node with puppet-agent for Linux
* [`windows`](#windows): Bootstrap a node with puppet-agent for Windows

## Tasks

### <a name="init"></a>`init`

Bootstrap a node with puppet-agent

**Supports noop?** false

#### Parameters

##### `master`

Data type: `String`

The fqdn of the master from which the puppet-agent should be bootstrapped

##### `cacert_content`

Data type: `Optional[String]`

The expected CA certificate content for the master

##### `certname`

Data type: `Optional[String]`

The certname with which the node should be bootstrapped

##### `environment`

Data type: `Optional[String]`

The environment in which the node should be bootstrapped

##### `set_noop`

Data type: `Optional[Boolean]`

The noop setting in the [agent] section of puppet.conf

##### `dns_alt_names`

Data type: `Optional[String]`

The DNS alt names with which the agent certificate should be generated

##### `custom_attribute`

Data type: `Optional[Array[Pattern[/\w+=\w+/]]]`

This setting is added to puppet.conf and included in the custom_attributes section of csr_attributes.yaml

##### `extension_request`

Data type: `Optional[Array[Pattern[/\w+=\w+/]]]`

This setting is added to puppet.conf and included in the extension_requests section of csr_attributes.yaml

##### `puppet_conf_settings`

Data type: `Optional[Array[Pattern[/\w+:\w+=.*/]]]`

Puppet conf settings. See https://www.puppet.com/docs/pe/2021.7/installing_nix_and_windows_agents_using_an_install_script.html#customize-install-script for usage instructions

### <a name="linux"></a>`linux`

Bootstrap a node with puppet-agent for Linux

**Supports noop?** false

#### Parameters

##### `master`

Data type: `String`

The fqdn of the master from which the puppet-agent should be bootstrapped

##### `cacert_content`

Data type: `Optional[String]`

The expected CA certificate content for the master

##### `certname`

Data type: `Optional[String]`

The certname with which the node should be bootstrapped

##### `environment`

Data type: `Optional[String]`

The environment in which the node should be bootstrapped

##### `set_noop`

Data type: `Optional[Boolean]`

The noop setting in the [agent] section of puppet.conf

##### `dns_alt_names`

Data type: `Optional[String]`

The DNS alt names with which the agent certificate should be generated

##### `custom_attribute`

Data type: `Optional[Array[Pattern[/\w+=\w+/]]]`

This setting is added to puppet.conf and included in the custom_attributes section of csr_attributes.yaml

##### `extension_request`

Data type: `Optional[Array[Pattern[/\w+=\w+/]]]`

This setting is added to puppet.conf and included in the extension_requests section of csr_attributes.yaml

##### `puppet_conf_settings`

Data type: `Optional[Array[Pattern[/\w+:\w+=.*/]]]`

Puppet conf settings. See https://www.puppet.com/docs/pe/2021.7/installing_nix_and_windows_agents_using_an_install_script.html#customize-install-script for usage instructions

### <a name="windows"></a>`windows`

Bootstrap a node with puppet-agent for Windows

**Supports noop?** false

#### Parameters

##### `master`

Data type: `String`

The fqdn of the master from which the puppet-agent should be bootstrapped

##### `cacert_content`

Data type: `Optional[String]`

The expected CA certificate content for the master

##### `certname`

Data type: `Optional[String]`

The certname with which the node should be bootstrapped

##### `environment`

Data type: `Optional[String]`

The environment in which the node should be bootstrapped

##### `set_noop`

Data type: `Optional[Boolean]`

The noop setting in the [agent] section of puppet.conf

##### `dns_alt_names`

Data type: `Optional[String]`

The DNS alt names with which the agent certificate should be generated

##### `custom_attribute`

Data type: `Optional[Array[Pattern[/\w+=\w+/]]]`

This setting is added to puppet.conf and included in the custom_attributes section of csr_attributes.yaml

##### `extension_request`

Data type: `Optional[Array[Pattern[/\w+=\w+/]]]`

This setting is added to puppet.conf and included in the extension_requests section of csr_attributes.yaml

##### `puppet_conf_settings`

Data type: `Optional[Array[Pattern[/\w+:\w+=.*/]]]`

Puppet conf settings. See https://www.puppet.com/docs/pe/2021.7/installing_nix_and_windows_agents_using_an_install_script.html#customize-install-script for usage instructions

