# Puppet Enterprise Management Tools

This repository is one of several that comprise the tooling used to manage
installations of Puppet Enterprise.

The index of repositories and documentation for these tools is at
[puppetlabs/pe-installer-shim](https://github.com/puppetlabs/pe-installer-shim).

# enterprise\_tasks

A collection of tasks and plans for the installation, management, and configuration of Puppet Enterprise.

#### Table of Contents

1. [Description](#description)
2. [Setup - The basics of getting started with enterprise\_tasks](#setup)
3. [Usage - Configuration options and additional functionality](#usage)
4. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
    * [Plans](#plans)
      * [Base Modulepath Plans](#base-modulepath-plans)
      * [Helper Plans](#helper-plans)
      * [Testing Plans](#testing-plans)
5. [Limitations - OS compatibility, etc.](#limitations)
6. [Development - Guide for contributing to the module](#development)

## Description

This Bolt module provides a variety of tasks for PE-related operations. See
[Reference](#reference) below for a list of plans (or bolt plan show once you
are setup). Of course, the individual tasks that make up each of those plans
are also available.

The module is shippped in PE as part of the
[pe-installer](https://github.com/puppetlabs/pe-installer-vanagon) package.

## Setup

First, this requires having an installation of Bolt. Steps for installing Bolt
can be found in the [Bolt
Documentation](https://www.puppet.com/docs/bolt/latest/bolt_installing).

Once you have a bolt OS package installed, run `bolt module install` from the
root of this repository to install its dependencies. Then you should be able
to list and run any of the plans from this module.

To include this module in your own Bolt project, add the git url and
branch to your bolt-project.yaml `modules` array.

```bolt-project.yaml
modules:
  - git: 'git@github.com:puppetlabs/enterprise_tasks'
    ref: main
```

## Usage

To show available tasks: `bolt task show`

To show available plans: `bolt plan show`

To run a task: `bolt task run enterprise_tasks::<name_of_task> <parameters>`

To run a plan: `bolt plan run enterprise_tasks::<name_of_plan> <parameters>`

### Tasks and Plans via PCP

This section contains results and relevant information from a spike into using PCP to run the various tasks and plans from this repo. This section is just to represent a somewhat hacky and temporary approach to running plans with PCP (pending a better solution once the work on Plans in PE is completed). `puppet infra run` can be used to invoke these commands when in a PE environment.

#### Using Tasks with PCP

##### Setup

* Certain Bolt actions require extra dependency modules
  - For built-in Bolt tasks, as well as `run_command` invocations in plans to work: the `bolt_shim` module is necessary, and should be available in /opt/puppetlabs/puppet/modules
  - For apply() to work (again plan-only, but it's in the tasks section because I don't want to just repeat this below...): the `apply_helpers` module is required and should be available in /opt/puppetlabs/puppet/modules

##### General Information

* It is relatively straightforward to get most tasks up and running via `puppet infra run` invocations
* Many, if not all, of our custom `enterprise_tasks` tasks work without needing to use any extra modules
* `puppet task` needs to be able to pick up whatever `enterprise_tasks` task we want to run
  - This can be done mostly simply by moving our `enterprise_tasks` module into /opt/puppetlabs/puppet/modules. As a side note, it would be nice to hide basically all of these tasks from the console when doing this (most are not particularly useful to a user, and I believe that most of the individual tasks are not). Clashing with other already-installed modules is a real concern if we need to take this approach in the future when actually adding support for PCP outside of manual hacking
* For dependency modules, only modules that tasks directly require need to be added to the puppet module directory (i.e. `ruby_task_helper`, in the case of basically all of our tasks)
* To actually run via PCP: pass in `--transport pcp` when invoking a task, or pass in the nodes you'd like the task to run against like so: `pcp://<puppet_certname>`

#### Using Plans with PCP

##### Setup

* Setup requirements are identical to running tasks: see "Setup" above
* Invocation is the same as above and can be done by using `--transport pcp` in a plan call or appending `pcp://` to any nodes passed to the plan

##### Potential Stumbling Blocks

* Having dependencies on non-task files (i.e. dependencies on certain puppet-enterprise-modules files) is a pain
* More investigation may be required, but the way we currently specify dependencies on puppet-enterprise-modules files for Bolt via `puppet infra run` does not work for running tasks via PCP (although there's one case where our dependencies will get picked up: when a task is literally running on "localhost")
  - This does not necessarily mean that it's not possible to provide these dependency files correctly; just that we will need to do it differently than how we currently do it for Bolt (which means that we may need clear differentiation between what tasks run on PCP only and what things do not, because the structuring of dependencies may be programatically different)
  - The upcoming Plans in PE work by Team Skeletor may cause this bullet point to be irrelevant and/or change
* Plans that stop various services that the orchestrator interacts with (like pe-puppetserver) will break this, but that's probably unavoidable

## Reference

### Plans

Use `bolt plan show` for the most current listing.

Not every plan is necessarily in use in a PE install.

The `puppet infra run` action includes certain plans for use in PE. (see the
[pe\_manager run
action](https://github.com/puppetlabs/puppet-enterprise-modules/blob/irving/modules/pe_manager/lib/puppet/face/infrastructure/run.rb))

#### Base Modulepath Plans

*Note* Use `puppet plan show` to list plans available to Orchestrator via the basemodulepath.

See [Adding new "basemodulepath" content](#adding-new-basemodulepath-content) for instructions on adding new content that should be installed to the basemodulepath in PE.

##### add\_platform.pp

Used to fetch puppet-agent packages for newer versions of the agent, and potentially new platforms that did not initially ship with PE
```
$puppet plan run enterprise_tasks::add_platform --params '{"os":"ubuntu", "version":"24.04", "target":"pe-primary.com"}'
```

##### agent\_cert\_regen.pp

Used to regenert Puppet agent certicates.
This plan can be called from commandline as below
```
$bolt plan run enterprise_tasks::agent_cert_regen --params '{ "agent":<agent>, "caserver":<caserver>, "dns_alt_names":"dns-alt-name-1,dns-alt-name-2", "extension_requests":{"pp_role":"webserver"}, "custom_attributes":{"challengePassword":"S3cr3tP@ssw0rd"}}'
```

##### convert\_legacy\_compiler.pp

Converts a compiler from the legacy type that only included Puppet Server, to one that also includes the PuppetDB service.

##### enable\_ha\_failover.pp

An HA helper plan, used to repurpose a failed primary as a replica after a replica has been promoted.

##### primary\_cert\_regen.pp

Used to regenerate the PE primary's certificate, helpful if the primary is renamed.
This plan can be called from commandline as below:
```
$bolt plan run enterprise_tasks::primary_cert_regen --params '{ "primary":"<primaryhost>", "dns_alt_names":"dns-alt-name-1,dns-alt-name-2", "extension_requests":{"pp_role":"webserver"}, "custom_attributes":{"challengePassword":"S3cr3tP@ssw0rd"} }'
```

##### rebuild\_ca.pp

Used to rebuild the Puppetserver's entire Certificate Authority.

#### Helper plans

Plans used by other plans.

##### create\_tempdirs.pp

Uses mktemp to generate unique working directories on all targets. Stores the
path to the directory as a variable 'workdir' on each target.

##### sync\_enterprise\_data.pp

Used to recover configuration on primary and sync it (user_data.conf and
nodes/\*) to a list of other infrastructure nodes.

Currently this plan is only used by the testing/upgrade_pe plan. It is not
clever enough to figure out what the rest of the infrastructure is from the
data it recovers, but could be improved to do so if necessary.

#### Testing Plans (Deprecated)

NOTE: These plans are deprecated in favor of the [PEADM
module](https://github.com/puppetlabs/puppetlabs-peadm) and should be removed
from this repository.

The plans/testing/\* plans were intended for use in internal testing pipelines.

## Limitations

This module is shipped with the pe-installer package, and is intended for use with PE installations from 2018.1.x forward.

## Development

### Adding new "basemodulepath" content

When adding a new plan or task to `enterprise_tasks` that will eventually be installed to PE's basemodulepath for use by Orchestrator: the name of the plan/task needs to be added to [base_modulepath.rb](./tools/base_modulepath.rb) under one of `INFRA_RUN_PLANS`, `INFRA_ACTION_PLANS`, `HA_TASKS`, or `INFRA_TASKS`, depending on how the plan/task is to be used. The base_modulepath.rb helper will be used by the pe-modules-vanagon packaging process to install only specific plans/tasks from this repo to the basemodulepath.

### Testing

Run:

`bundle exec rake test`

to run all of the test targets.

There is a `validate_plans` target which can be run to get `puppet parser
validate --tasks` feedback for all the plans.

## Contributing

Commit messages should follow standard Puppet practice. The header should start
with a (TICKET-1234) reference or (maint). Commit messages should provide a
summary of what the problem was, what you changed and how the change fixes the
problem. Typos are an obvious exception.
