# @summary A function to generate options for the enterprise_platform class.
#
# @param name [String] The name of the platform.
#
# @param os_name [String] The name of the os.
#
# @param architecture [String] The architecture of the os.
#
# @param os_version [String] The version of the os.
#
# @param fips [Boolean] A boolean to determine if fips is enabled.
#
# @option codename [Optional[String]] The codename of the os.
#
# @option agent_version [Optional[String]] The version of the agent.
#
# @option pe_version [Optional[String]] The version of the PE.
#
# @return [Hash] The options hash.
#
# @example
#   enterprise_tasks::resource_options('debian-7-x86_64', 'debian', 'x86_64', '12', false, 'bookworm', '8.9.0', '2019.0.0')
#   Would return: { 'debian-7-x86_64' => {
#     'os_name' => 'debian',
#     'os_arch' => 'x86_64',
#     'os_version' => '12',
#     'fips' => false,
#     'codename' => 'bookworm',
#     'agent_version' => '8.9.0',
#     'pe_version' => '2019.0.0'
#   } }
Puppet::Functions.create_function('enterprise_tasks::resource_options') do
  dispatch :resource_options do
    param 'String', :name
    param 'String', :os_name
    param 'String', :architecture
    param 'String', :os_version
    param 'Boolean', :fips
    param 'Optional[String]', :codename
    param 'Optional[String]', :agent_version
    param 'Optional[String]', :pe_version
    return_type 'Hash'
  end

  def resource_options(name, os_name, architecture, os_version, fips, codename, agent_version, pe_version)
    params = {}
    params[:os_name] = os_name
    params[(os_name != 'windows') ? :os_arch : :arch] = architecture
    params[:os_version] = os_version
    params[:fips] = fips
    params[:codename] = codename if codename
    params[:agent_version] = agent_version if agent_version
    params[:pe_version] = pe_version if pe_version
    { name => params }
  end
end
