# Preps each of the given remote nodes with the public key used for test package signing.
# On each node, the public key from the keypair used for signing local test packages is
# added to the appropriate package manager based on the platform for each node.
#
# This is only intended to be run on primary platforms (el, sles, ubuntu).
#
# @param nodes [TargetSpec] nodes to add the key to.
# @param gpg_public_key [String] path to the local gpg public key to copy and
#   import. Defaults to the testing key present in this modules files/gpg directory.
plan enterprise_tasks::testing::prep_test_package_gpg(
  TargetSpec $nodes,
  String $gpg_public_key = 'enterprise_tasks/gpg/GPG-KEY-testpackaging.pub',
  String $remote_key_path = '/root/GPG-KEY-package-test.pub'
) {
  upload_file($gpg_public_key, $remote_key_path, $nodes)

  run_plan(facts, 'targets' => $nodes)
  get_targets($nodes).each |$node| {
    $osfacts = $node.facts['os']
    case $osfacts['family'] {
      'RedHat','SLES','Suse': {
        run_command("rpm --import ${remote_key_path}", $node)
      }
      'Debian': {
        run_command("cat ${remote_key_path} | apt-key add -", $node)
      }
      default: {
        fail_plan("Unable to import test gpg public key for platform: '${osfacts}'")
      }
    }
  }
}
