plan enterprise_tasks::testing::upgrade_replica(
  TargetSpec $replicas,
  Variant[Target,String] $primary,
  Integer $replication_timeout = 1800,
) {
  $replica_targets = get_targets($replicas)
  $primary_target = get_targets($primary)[0]

  enterprise_tasks::message('upgrade_replica', 'Checking connectivity to infrastructure nodes.')
  enterprise_tasks::test_connection($primary_target)
  enterprise_tasks::test_connection($replica_targets)

  enterprise_tasks::get_facts_on($primary_target)
  $pg_version = $primary_target.facts['pe_postgresql_info']['installed_server_version']

  $replica_targets.each |$replica| {
    run_task(
      'enterprise_tasks::run_secondary_upgrade_script',
      $replica,
      'primary'  => $primary,
    )

    return run_task(
      'enterprise_tasks::check_pglogical_replica_status',
      $replica,
      'timeout'    => $replication_timeout,
      'pg_version' => $pg_version,
    )
  }
  enterprise_tasks::message('upgrade_replica', 'Validating that all replica nodes are steady state.')
  run_task(enterprise_tasks::run_puppet, $replica_targets, 'exit_codes' => [0])
}
